/*
 * Decompiled with CFR 0.152.
 */
package io.aether.cli;

import io.aether.api.common.CryptoLib;
import io.aether.api.common.ServerDescriptor;
import io.aether.cli.CliApi;
import io.aether.cli.CliState;
import io.aether.cloud.client.ClientStateInMemory;
import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;
import io.aether.utils.consoleCanonical.ConsoleMgrCanonical;
import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;

public class CLI {
    public final CliApi api;
    private final ARFuture<Object> resultFuture;
    private final CliState cliState = new CliState();

    public CLI(String ... aa) {
        this.cliState.load();
        this.api = new CliApi(this.cliState);
        var consoleMgr = new ConsoleMgrCanonical(this, aa){

            public String getAppName() {
                return "aether-cli";
            }
        };
        consoleMgr.footer = "For more information, please visit the website https://aethernet.io";
        consoleMgr.regConverter(CTypeI.of(CryptoLib.class), CryptoLib::valueOf);
        consoleMgr.regConverter(CTypeI.of(UUID.class), s -> {
            if (s == null) {
                return null;
            }
            return this.api.resolveUuid((String)s);
        });
        consoleMgr.regResultConverter("bin", CTypeI.of(ClientStateInMemory.class), ClientStateInMemory::save);
        this.setupMsgConverters(consoleMgr);
        this.setupClientStateJsonConverter(consoleMgr);
        this.resultFuture = consoleMgr.execute(this.api);
        this.resultFuture.mapRFuture(v -> ((AFuture)this.api.destroyer.destroy(true).timeout(10, () -> Log.warn((String)"Timeout destroying CLI resources", (LNode[])new LNode[0]))).mapRFuture(() -> null)).timeout(10, () -> Log.warn((String)"Timeout result cli", (LNode[])new LNode[0]));
    }

    private void setupMsgConverters(ConsoleMgrCanonical consoleMgr) {
        consoleMgr.regResultConverterCtx("bin", CTypeI.of(CliApi.Msg.class), (ctx, v) -> {
            if (ctx.isToFile() && ctx.getFileName() == null) {
                ctx.setFileName(v.address.toString());
            }
            return v.data;
        });
        consoleMgr.regResultConverterCtx("json", CTypeI.of(CliApi.Msg.class), (ctx, v) -> {
            if (ctx.isToFile() && ctx.getFileName() == null) {
                ctx.setFileName(v.address.toString());
            }
            Map<String, byte[]> m = Map.of("uid", v.address, "data", v.data);
            return RU.toJson(m).toString().getBytes(StandardCharsets.UTF_8);
        });
        consoleMgr.regResultConverterCtx("hex", CTypeI.of(CliApi.Msg.class), (ctx, v) -> {
            if (ctx.isToFile() && ctx.getFileName() == null) {
                ctx.setFileName(v.address.toString());
            }
            return HexUtils.toHexString((byte[])v.data).getBytes();
        });
        consoleMgr.regResultConverterCtx("utf8", CTypeI.of(CliApi.Msg.class), (ctx, v) -> {
            AString s = AString.of();
            s.add((Object)v.address).add(" -> ").add(new String(v.data));
            return s.getBytes();
        });
    }

    private void setupClientStateJsonConverter(ConsoleMgrCanonical consoleMgr) {
        consoleMgr.regResultConverter("json", CTypeI.of(ClientStateInMemory.class), v -> {
            Map<String, Map> m = Map.of("uid", v.getUid(), "alias", v.getAlias(), "cloud", v.getCloud(v.getUid()), "serverDescriptors", Flow.flow((short[])v.getCloud(v.getUid()).getData()).mapToInt().mapToObj(arg_0 -> ((ClientStateInMemory)v).getServerDescriptor(arg_0)).toMapExtractKey(ServerDescriptor::getId));
            return RU.toJson(m).toString().getBytes(StandardCharsets.UTF_8);
        });
    }

    public ARFuture<Object> getResultFuture() {
        return this.resultFuture;
    }

    public static void main(String ... aa) {
        new CLI(aa);
    }
}

