/*
 * Decompiled with CFR 0.152.
 */
package io.aether.cli;

import com.google.gson.GsonBuilder;
import io.aether.StandardUUIDs;
import io.aether.api.common.AccessGroup;
import io.aether.api.common.CryptoLib;
import io.aether.api.common.ServerDescriptor;
import io.aether.cli.CliState;
import io.aether.cloud.client.AetherCloudClient;
import io.aether.cloud.client.ClientState;
import io.aether.cloud.client.ClientStateInMemory;
import io.aether.cloud.client.MessageEventListener;
import io.aether.cloud.client.MessageNode;
import io.aether.common.AccessGroupI;
import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.AString;
import io.aether.utils.Destroyer;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.consoleCanonical.ConsoleMgrCanonical;
import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.Destroyable;
import io.aether.utils.slots.EventConsumer;
import io.aether.utils.slots.EventConsumerWithQueue;
import io.aether.utils.streams.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@ConsoleMgrCanonical.Doc(value="Command Line Interface API for Aether Cloud Client operations.")
public class CliApi {
    private static final Executor CLI_EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "CLI-Async-Worker"));
    private static final Executor DESTROY_EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "CLI-Destroy-Worker"));
    public final Destroyer destroyer = new Destroyer("CliApi");
    public CreateApi createApi;
    public ShowApi showApi;
    public SetApi setApi;
    private final CliState cliState;
    private final String UUID_ALIASES_DOC = "Known static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)";

    public CliApi(CliState cliState) {
        this.cliState = cliState;
    }

    private static void logFlow(String message, Object ... args) {
        ArrayList<Object> l = new ArrayList<Object>(Arrays.asList(args));
        l.add("SystemComponent");
        l.add("CLI");
        Log.info((String)message, (Object[])l.toArray());
    }

    public UUID resolveUuid(String uuidOrAlias) {
        if (uuidOrAlias == null) {
            return null;
        }
        if (this.cliState.hasAlias(uuidOrAlias)) {
            return UUID.fromString(this.cliState.getUuidForAlias(uuidOrAlias));
        }
        String upper = uuidOrAlias.toUpperCase();
        if (this.cliState.hasAlias(upper)) {
            return UUID.fromString(this.cliState.getUuidForAlias(upper));
        }
        switch (upper) {
            case "TEST": {
                return StandardUUIDs.TEST_UID;
            }
            case "ROOT": {
                return StandardUUIDs.ROOT_UID;
            }
            case "ANONYMOUS": {
                return StandardUUIDs.ANONYMOUS_UID;
            }
        }
        try {
            return UUID.fromString(uuidOrAlias);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid UUID or alias: '" + uuidOrAlias + "'", e);
        }
    }

    private static void completeCliSession(Destroyer cliDestroyer, AFuture future) {
        ((AFuture)future.to(CLI_EXECUTOR, () -> {
            CliApi.logFlow("Asynchronous operation finished. Completing root CLI destroyer.", new Object[0]);
            DESTROY_EXECUTOR.execute(() -> cliDestroyer.destroy(true).to(() -> {
                CliApi.logFlow("Root CLI destroyer completed. Checking active threads.", new Object[0]);
                Thread.getAllStackTraces().keySet().stream().filter(t -> t.isAlive() && !t.isDaemon()).forEach(t -> Log.warn((String)"Non-daemon thread still active: $name ($group)", (Object[])new Object[]{"name", t.getName(), "group", t.getThreadGroup().getName()}));
            }));
        })).onError(e -> {
            CliApi.logFlow("Error during asynchronous operation. Completing root CLI destroyer with error.", "error", e.getMessage());
            DESTROY_EXECUTOR.execute(() -> cliDestroyer.destroy(true));
        });
    }

    @ConsoleMgrCanonical.Doc(value="Safely destroys CLI resources")
    public AFuture safeDestroy() {
        AFuture destroyFuture = AFuture.make();
        DESTROY_EXECUTOR.execute(() -> {
            try {
                CliApi.logFlow("Starting safe destroy of CLI resources", new Object[0]);
                ((AFuture)this.destroyer.destroy(true).timeout(10, () -> Log.warn((String)"Timeout during safe destroy", (LNode[])new LNode[0]))).to(destroyFuture);
            }
            catch (Exception e) {
                Log.error((String)"Error during safe destroy", (Throwable)e, (Object[])new Object[0]);
                destroyFuture.error((Throwable)e);
            }
        });
        return destroyFuture;
    }

    @ConsoleMgrCanonical.Doc(value="Show version of cli instrument")
    @ConsoleMgrCanonical.Example(value="$exCmd version")
    public String version() {
        String string;
        CliApi.logFlow("Executing command: version", new Object[0]);
        BufferedReader is = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/aether-cli-version.txt")));
        try {
            string = is.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                RU.error((Throwable)e);
                return null;
            }
        }
        is.close();
        return string;
    }

    @ConsoleMgrCanonical.Api
    @ConsoleMgrCanonical.Doc(value="Create a client or group")
    public CreateApi create(@ConsoleMgrCanonical.Doc(value="Specify a time limit for the object creation") @ConsoleMgrCanonical.Optional(value="5") int timeout) {
        CliApi.logFlow("Executing command: create", "timeout", timeout);
        this.createApi = new CreateApi();
        return this.createApi;
    }

    @ConsoleMgrCanonical.Api
    @ConsoleMgrCanonical.Doc(value="Change properties of a client or group")
    public ChangeApi change(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state) {
        CliApi.logFlow("Executing command: change", "stateFile", state);
        ClientStateInMemory loadedState = ClientStateInMemory.load((File)state);
        if (loadedState == null) {
            throw new IllegalStateException("Command requires a valid state file, but it was not found or was corrupted. Default path is '" + state.getName() + "'. Please run 'create client' first, or specify a valid state file with --state.");
        }
        AetherCloudClient client = new AetherCloudClient((ClientState)loadedState);
        this.destroyer.add((Destroyable)client);
        return new ChangeApi(client);
    }

    @ConsoleMgrCanonical.Doc(value="Check the possibility of sending messages between two clients")
    @ConsoleMgrCanonical.Example(value="$exCmd check-access --uid1 TEST --uid2 my-friend-alias")
    public ARFuture<Boolean> checkAccess(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state, @ConsoleMgrCanonical.Doc(value="Client 1 UUID or alias. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") UUID uid1, @ConsoleMgrCanonical.Doc(value="Client 2 UUID or alias. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") UUID uid2) {
        CliApi.logFlow("Executing command: checkAccess", "stateFile", state, "uid1", uid1, "uid2", uid2);
        ClientStateInMemory loadedState = ClientStateInMemory.load((File)state);
        if (loadedState == null) {
            return ARFuture.doThrow((Throwable)new IllegalStateException("Command requires a valid state file, but it was not found or was corrupted. Default path is '" + state.getName() + "'. Please run 'create client' first, or specify a valid state file with --state."));
        }
        AetherCloudClient client = new AetherCloudClient((ClientState)loadedState);
        this.destroyer.add((Destroyable)client);
        AetherCloudClient finalClient = client;
        return ARFuture.run2((Executor)CLI_EXECUTOR, () -> finalClient.checkAccess(uid1, uid2)).apply(() -> CliApi.completeCliSession(this.destroyer, finalClient.destroy(true)));
    }

    @ConsoleMgrCanonical.Api
    @ConsoleMgrCanonical.Doc(value="Send a message to an address")
    public SendApi send(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state, @ConsoleMgrCanonical.Doc(value="Destination UUID address or alias. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") UUID address) {
        CliApi.logFlow("Executing command: send", "stateFile", state, "address", address);
        ClientStateInMemory loadedState = ClientStateInMemory.load((File)state);
        if (loadedState == null) {
            throw new IllegalStateException("Command requires a valid state file, but it was not found or was corrupted. Default path is '" + state.getName() + "'. Please run 'create client' first, or specify a valid state file with --state.");
        }
        AetherCloudClient client = new AetherCloudClient((ClientState)loadedState);
        this.destroyer.add((Destroyable)client);
        MessageNode st = client.getMessageNode(address, MessageEventListener.DEFAULT);
        return new SendApi(st, client);
    }

    @ConsoleMgrCanonical.Api
    @ConsoleMgrCanonical.Doc(value="Show client state, groups, aliases, and incoming messages")
    public ShowApi show() {
        CliApi.logFlow("Executing command: show", new Object[0]);
        this.showApi = new ShowApi(this.cliState);
        return this.showApi;
    }

    @ConsoleMgrCanonical.Api
    @ConsoleMgrCanonical.Doc(value="Set properties, like user-defined aliases")
    public SetApi set() {
        CliApi.logFlow("Executing command: set", new Object[0]);
        this.setApi = new SetApi(this, this.cliState);
        return this.setApi;
    }

    @ConsoleMgrCanonical.Doc(value="API for creating resources (client, group).")
    public class CreateApi {
        @ConsoleMgrCanonical.Doc(value="Create a new client")
        @ConsoleMgrCanonical.Example(value="$exCmd create client --parent TEST --alias my-new-client")
        public ARFuture<ClientState> client(@ConsoleMgrCanonical.Optional(value="TEST") @ConsoleMgrCanonical.Doc(value="Parent client UUID or alias. Defaults to TEST.\nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") UUID parent, @ConsoleMgrCanonical.Optional(value="tcp://registration.aethernet.io:9010") @ConsoleMgrCanonical.Doc(value="Registration URI") URI regUri, @ConsoleMgrCanonical.Optional(value="SODIUM") @ConsoleMgrCanonical.Doc(value="Cryptographic library to use") CryptoLib cryptoLib, @ConsoleMgrCanonical.Optional(value="false") @ConsoleMgrCanonical.Doc(value="Use development registration URI") boolean dev, @ConsoleMgrCanonical.Optional(value="bin") @ConsoleMgrCanonical.Doc(value="Output format for client state file (e.g., bin)") String fileOutFormat, @ConsoleMgrCanonical.Optional(value="state.bin") @ConsoleMgrCanonical.Doc(value="File path for saving the client state") File fileOut, @ConsoleMgrCanonical.Optional @ConsoleMgrCanonical.Doc(value="A custom alias to save for the new client's UUID in ~/.aether-cli-state.json") String alias) {
            CliApi.logFlow("CreateApi: client creation started", "parent", parent, "alias", alias);
            if (dev) {
                regUri = URI.create("tcp://reg-dev.aethernet.io:9010");
            }
            ClientStateInMemory state = new ClientStateInMemory(parent, List.of(regUri), null, cryptoLib);
            AetherCloudClient client = new AetherCloudClient((ClientState)state);
            CliApi.this.destroyer.add((Destroyable)client);
            Destroyer apiDestroyer = CliApi.this.destroyer;
            ARFuture resultFuture = ARFuture.make();
            ARFuture registrationChain = client.startFuture.mapRFuture(() -> state);
            ARFuture resolutionChain = registrationChain.mapRFuture(stateValue -> {
                UUID selfUid = stateValue.getUid();
                ARFuture cloudFuture = client.getCloud(selfUid);
                return cloudFuture.mapRFuture(cloud -> {
                    if (cloud == null || cloud.getData().length == 0) {
                        CliApi.logFlow("CreateApi: Cloud is empty, skipping server resolution.", new Object[0]);
                        return ARFuture.of((Object)stateValue);
                    }
                    CliApi.logFlow("CreateApi: Cloud found, resolving $serversCount server descriptors.", "serversCount", cloud.getData().length);
                    List serverFutures = Flow.flow((short[])cloud.getData()).mapToInt().mapToObj(arg_0 -> ((AetherCloudClient)client).getServer(arg_0)).toList();
                    return ARFuture.all(ServerDescriptor.class, (Flow)Flow.flow((List)serverFutures)).map(descriptions -> stateValue);
                });
            });
            resolutionChain.to(resultFuture).onError(arg_0 -> ((ARFuture)resultFuture).tryError(arg_0));
            return resultFuture.apply(() -> {
                if (alias != null && !alias.isBlank()) {
                    CliApi.this.cliState.addAlias(alias, state.getUid().toString());
                    CliApi.logFlow("CreateApi: Saved new alias '" + alias + "' for UUID " + String.valueOf(state.getUid()), new Object[0]);
                }
                CliApi.logFlow("CreateApi: Client creation finished. Starting asynchronous destroy.", new Object[0]);
                CliApi.completeCliSession(apiDestroyer, client.destroy(true));
            });
        }

        @ConsoleMgrCanonical.Doc(value="Create a new access group")
        @ConsoleMgrCanonical.Example(value="$exCmd create group --owner TEST TEST,ROOT,my-friend-alias")
        public ARFuture<Long> group(@ConsoleMgrCanonical.Optional(value="state.bin") @ConsoleMgrCanonical.Doc(value="Client state file used for operation") File state, @ConsoleMgrCanonical.Optional @ConsoleMgrCanonical.Doc(value="Owner UUID or alias of the new group. Defaults to client's UID from state file.\nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") UUID owner, @ConsoleMgrCanonical.Doc(value="Set of client UUIDs or aliases to initially include in the group. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") @ConsoleMgrCanonical.Optional Set<UUID> uids) {
            CliApi.logFlow("CreateApi: group creation started", new Object[0]);
            ClientStateInMemory loadedState = ClientStateInMemory.load((File)state);
            if (loadedState == null) {
                return ARFuture.doThrow((Throwable)new IllegalStateException("Command requires a valid state file, but it was not found or was corrupted. Default path is '" + state.getName() + "'. Please run 'create client' first, or specify a valid state file with --state."));
            }
            AetherCloudClient client = new AetherCloudClient((ClientState)loadedState);
            CliApi.this.destroyer.add((Destroyable)client);
            UUID ownerUuid = owner;
            if (ownerUuid == null) {
                ownerUuid = client.getUid();
            }
            if (uids == null) {
                uids = Set.of();
            }
            UUID finalOwner = ownerUuid;
            Set<UUID> finalUids = uids;
            Destroyer apiDestroyer = CliApi.this.destroyer;
            return ARFuture.run((Executor)CLI_EXECUTOR, () -> (AccessGroupI)client.createAccessGroupWithOwner(finalOwner, finalUids.toArray(new UUID[0])).get()).apply(() -> {
                CliApi.logFlow("CreateApi: group creation finished. Starting asynchronous destroy.", new Object[0]);
                CliApi.completeCliSession(apiDestroyer, client.destroy(true));
            }).map(AccessGroupI::getId);
        }
    }

    @ConsoleMgrCanonical.Doc(value="API for changing resources (e.g., groups).")
    public class ChangeApi {
        private final AetherCloudClient client;

        public ChangeApi(AetherCloudClient client) {
            this.client = client;
        }

        @ConsoleMgrCanonical.Api
        @ConsoleMgrCanonical.Doc(value="Change an access group")
        public ChangeGroupApi group(@ConsoleMgrCanonical.Doc(value="Access group ID") long id) {
            return new ChangeGroupApi(id, this.client);
        }

        @ConsoleMgrCanonical.Doc(value="API for changing a specific access group.")
        public class ChangeGroupApi {
            private final long id;
            private final AetherCloudClient client;

            public ChangeGroupApi(long id, AetherCloudClient client) {
                this.id = id;
                this.client = client;
            }

            @ConsoleMgrCanonical.Doc(value="Add clients to an access group")
            @ConsoleMgrCanonical.Example(value="$exCmd change group 123456 add TEST,my-friend-alias")
            public AFuture add(@ConsoleMgrCanonical.Doc(value="Set of client UUIDs or aliases to add. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") @ConsoleMgrCanonical.StdIn Set<UUID> uid) {
                CliApi.logFlow("ChangeGroupApi: add started", "groupId", this.id);
                AFuture res = AFuture.make();
                Destroyer apiDestroyer = CliApi.this.destroyer;
                AFuture.run((Executor)CLI_EXECUTOR, () -> this.client.getAuthApi(a -> {
                    CliApi.logFlow("ChangeGroupApi: got AuthApi, starting add op", new Object[0]);
                    AFuture.all((Collection)Flow.flow((Set)uid).map(u -> a.addToAccessGroup(this.id, u)).map(ARFuture::toFuture).toList()).to(res);
                }));
                return res.apply(() -> {
                    CliApi.logFlow("ChangeGroupApi: add finished. Starting asynchronous destroy.", new Object[0]);
                    CliApi.completeCliSession(apiDestroyer, this.client.destroy(true));
                });
            }

            @ConsoleMgrCanonical.Doc(value="Remove clients from an access group")
            @ConsoleMgrCanonical.Example(value="$exCmd change group 123456 remove my-friend-alias")
            public AFuture remove(@ConsoleMgrCanonical.Doc(value="Set of client UUIDs or aliases to remove. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") Set<UUID> uid) {
                CliApi.logFlow("ChangeGroupApi: remove started", "groupId", this.id);
                AFuture res = AFuture.make();
                Destroyer apiDestroyer = CliApi.this.destroyer;
                AFuture.run((Executor)CLI_EXECUTOR, () -> this.client.getAuthApi(a -> {
                    CliApi.logFlow("ChangeGroupApi: got AuthApi, starting remove op", new Object[0]);
                    AFuture.all((Collection)Flow.flow((Set)uid).map(u -> a.removeFromAccessGroup(this.id, u)).map(ARFuture::toFuture).toList()).to(res);
                }));
                return res.apply(() -> {
                    CliApi.logFlow("ChangeGroupApi: remove finished. Starting asynchronous destroy.", new Object[0]);
                    CliApi.completeCliSession(apiDestroyer, this.client.destroy(true));
                });
            }
        }
    }

    @ConsoleMgrCanonical.Doc(value="API for sending messages.")
    public class SendApi {
        private final MessageNode st;
        private final AetherCloudClient client;

        public SendApi(MessageNode st, AetherCloudClient client) {
            this.st = st;
            this.client = client;
        }

        @ConsoleMgrCanonical.Doc(value="Send a text message")
        @ConsoleMgrCanonical.Example(value="$exCmd send TEST text \"Hello, world!\"")
        public AFuture text(@ConsoleMgrCanonical.Doc(value="Text content to send") String text) {
            CliApi.logFlow("SendApi: sending text message", "textLength", text.length());
            AFuture res = AFuture.make();
            AFuture.run((Executor)CLI_EXECUTOR, () -> this.st.send(Value.ofForce((Object)text.getBytes(StandardCharsets.UTF_8)).linkFuture(res))).onError(arg_0 -> ((AFuture)res).error(arg_0));
            Destroyer apiDestroyer = CliApi.this.destroyer;
            return (AFuture)res.to(() -> {
                CliApi.logFlow("SendApi: send finished. Starting asynchronous destroy.", new Object[0]);
                CliApi.completeCliSession(apiDestroyer, this.client.destroy(true));
            });
        }

        @ConsoleMgrCanonical.Doc(value="Send file content")
        @ConsoleMgrCanonical.Example(value="$exCmd send TEST file my_document.pdf")
        public AFuture file(@ConsoleMgrCanonical.Doc(value="File to send") File file) {
            CliApi.logFlow("SendApi: sending file", "fileName", file.getName());
            AFuture res = AFuture.make();
            AFuture.run((Executor)CLI_EXECUTOR, () -> {
                try (FileInputStream is = new FileInputStream(file);){
                    byte[] data = is.readAllBytes();
                    this.st.send(Value.ofForce((Object)data, o -> {
                        res.done();
                        CliApi.logFlow("SendApi: file message operation completed (sent to buffer)", new Object[0]);
                    }));
                }
                catch (Exception e) {
                    RU.error((Throwable)e);
                    res.error((Throwable)e);
                }
            });
            Destroyer apiDestroyer = CliApi.this.destroyer;
            return res.apply(() -> {
                CliApi.logFlow("SendApi: send finished. Starting asynchronous destroy.", new Object[0]);
                CliApi.completeCliSession(apiDestroyer, this.client.destroy(true));
            });
        }

        @ConsoleMgrCanonical.Doc(value="Send data from standard input")
        @ConsoleMgrCanonical.Example(value="echo \"data\" | $exCmd send TEST stdin")
        public AFuture stdIn(@ConsoleMgrCanonical.Doc(value="Data read from standard input") @ConsoleMgrCanonical.StdIn byte[] data) {
            CliApi.logFlow("SendApi: sending stdin data", "dataLength", data.length);
            AFuture res = AFuture.make();
            AFuture.run((Executor)CLI_EXECUTOR, () -> this.st.send(Value.ofForce((Object)data).linkFuture(res))).onError(arg_0 -> ((AFuture)res).error(arg_0));
            Destroyer apiDestroyer = CliApi.this.destroyer;
            return res.apply(() -> {
                CliApi.logFlow("SendApi: send (stdin) finished. Starting asynchronous destroy.", new Object[0]);
                CliApi.completeCliSession(apiDestroyer, this.client.destroy(true));
            });
        }
    }

    @ConsoleMgrCanonical.Doc(value="API for showing resources.")
    public class ShowApi {
        private final CliState cliState;
        public EventConsumer<Msg> messages = new EventConsumerWithQueue();

        public ShowApi(CliState cliState) {
            this.cliState = cliState;
        }

        private ClientStateInMemory loadRequiredState(File stateFile) {
            ClientStateInMemory state = ClientStateInMemory.load((File)stateFile);
            if (state == null) {
                throw new IllegalStateException("Command requires a valid state file, but it was not found or was corrupted. Default path is '" + stateFile.getName() + "'. Please run 'create client' first, or specify a valid state file with --state.");
            }
            return state;
        }

        @ConsoleMgrCanonical.Doc(value="Show all user-defined aliases from ~/.aether-cli-state.json")
        @ConsoleMgrCanonical.Example(value="$exCmd show aliases")
        public String aliases() {
            return new GsonBuilder().setPrettyPrinting().create().toJson(this.cliState.getAliases());
        }

        @ConsoleMgrCanonical.Doc(value="Show client state. Use --console json for JSON output.")
        @ConsoleMgrCanonical.Example(value="$exCmd show state")
        public ClientStateInMemory state(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state) {
            return this.loadRequiredState(state);
        }

        @ConsoleMgrCanonical.Doc(value="Show all access groups for a client")
        @ConsoleMgrCanonical.Example(value="$exCmd show groups -c TEST")
        @ConsoleMgrCanonical.Alias(value="g")
        public ARFuture<Set<Long>> groups(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state, @ConsoleMgrCanonical.Doc(value="Specified client UID or alias. Defaults to client's UID from state file.\nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") @ConsoleMgrCanonical.Optional @ConsoleMgrCanonical.Alias(value="c") UUID targetClient) {
            ClientStateInMemory requiredState;
            try {
                requiredState = this.loadRequiredState(state);
            }
            catch (Exception e) {
                return ARFuture.doThrow((Throwable)e);
            }
            AetherCloudClient client = AetherCloudClient.of((ClientState)requiredState);
            CliApi.this.destroyer.add((Destroyable)client);
            UUID targetUuid = targetClient;
            if (targetUuid == null) {
                targetUuid = client.getUid();
            }
            UUID finalTargetClient = targetUuid;
            ARFuture res = ARFuture.make();
            CLI_EXECUTOR.execute(() -> client.getClientGroups(finalTargetClient).to(res));
            return res.apply(() -> CliApi.completeCliSession(CliApi.this.destroyer, client.destroy(true)));
        }

        @ConsoleMgrCanonical.Doc(value="Show the contents (details) of the access groups for the specified IDs")
        @ConsoleMgrCanonical.Alias(value="gd")
        @ConsoleMgrCanonical.Example(value="$exCmd show groups-details 123456,789012")
        public ARFuture<List<AccessGroup>> groupsDetails(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state, @ConsoleMgrCanonical.Doc(value="IDs of access groups, separated by comma") Set<Long> ids) {
            ClientStateInMemory requiredState;
            try {
                requiredState = this.loadRequiredState(state);
            }
            catch (Exception e) {
                return ARFuture.doThrow((Throwable)e);
            }
            AetherCloudClient client = AetherCloudClient.of((ClientState)requiredState);
            CliApi.this.destroyer.add((Destroyable)client);
            ARFuture res = ARFuture.make();
            CLI_EXECUTOR.execute(() -> ARFuture.all((List)Flow.flow((Set)ids).map(groupId -> client.getGroup(groupId.longValue()).map(v -> v)).toList()).to(res));
            return res.apply(() -> CliApi.completeCliSession(CliApi.this.destroyer, client.destroy(true)));
        }

        @ConsoleMgrCanonical.Doc(value="Show all clients that the current client can access. This function does not work for public clients.")
        @ConsoleMgrCanonical.Alias(value="aac")
        @ConsoleMgrCanonical.Example(value="$exCmd show all-accessed-clients")
        public ARFuture<Set<UUID>> allAccessedClients(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state, @ConsoleMgrCanonical.Doc(value="Specified client UID or alias. Defaults to client's UID from state file.\nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") @ConsoleMgrCanonical.Optional @ConsoleMgrCanonical.Alias(value="c") UUID targetClient) {
            ClientStateInMemory requiredState;
            try {
                requiredState = this.loadRequiredState(state);
            }
            catch (Exception e) {
                return ARFuture.doThrow((Throwable)e);
            }
            AetherCloudClient client = AetherCloudClient.of((ClientState)requiredState);
            CliApi.this.destroyer.add((Destroyable)client);
            UUID targetUuid = targetClient;
            if (targetUuid == null) {
                targetUuid = client.getUid();
            }
            UUID finalTargetClient = targetUuid;
            ARFuture res = ARFuture.make();
            CLI_EXECUTOR.execute(() -> client.getAllAccessedClients(finalTargetClient).to(res));
            return res.apply(() -> CliApi.completeCliSession(CliApi.this.destroyer, client.destroy(true)));
        }

        @ConsoleMgrCanonical.Doc(value="Wait for and show incoming messages")
        @ConsoleMgrCanonical.Example(value="$exCmd show messages --wait-time 10000 --filter my-friend-alias")
        public EventConsumer<Msg> messages(@ConsoleMgrCanonical.Doc(value="Previously saved client state file") @ConsoleMgrCanonical.Optional(value="state.bin") File state, @ConsoleMgrCanonical.Doc(value="Filter messages by sender UUIDs or aliases. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") @ConsoleMgrCanonical.Optional Set<UUID> filter, @ConsoleMgrCanonical.Doc(value="Exclude messages from these sender UUIDs or aliases. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") @ConsoleMgrCanonical.Optional Set<UUID> not, @ConsoleMgrCanonical.Optional(value="5000") @ConsoleMgrCanonical.Doc(value="The time in milliseconds to wait for new messages. After timeout, the client session is closed.") long waitTime, @ConsoleMgrCanonical.Optional(value="bin") @ConsoleMgrCanonical.Doc(value="Output format for messages (e.g., bin, json, human)") String fileOutFormat, @ConsoleMgrCanonical.Optional(value="message") @ConsoleMgrCanonical.Doc(value="Specify the file name template for output") File fileOut, @ConsoleMgrCanonical.Optional(value="utf8") @ConsoleMgrCanonical.Doc(value="Console output encoding/format (e.g., utf8, json, bin)") String console, @ConsoleMgrCanonical.Optional(value="true") @ConsoleMgrCanonical.Doc(value="Set true if you want to append data to the file, false to overwrite") boolean fileAppend) {
            ClientStateInMemory requiredState = this.loadRequiredState(state);
            CliApi.logFlow("ShowApi: messages command started", "waitTimeMs", waitTime, "filterUids", filter, "notUids", not);
            AetherCloudClient client = new AetherCloudClient((ClientState)requiredState);
            CliApi.this.destroyer.add((Destroyable)client);
            CliApi.logFlow("ShowApi: Client instance created", "clientUid", client.getUid());
            Destroyer apiDestroyer = CliApi.this.destroyer;
            client.onClientStream(m -> {
                UUID consumerUid = m.getConsumerUUID();
                CliApi.logFlow("ShowApi: received new MessageNode stream", "consumerUid", consumerUid);
                m.toConsumer(d -> {
                    CliApi.logFlow("ShowApi: Message data received from stream", "from", consumerUid, "dataLength", ((byte[])d).length);
                    boolean isFiltered = false;
                    if (filter != null && !filter.contains(consumerUid)) {
                        CliApi.logFlow("ShowApi: Message SKIPPED (Filter check failed)", "from", consumerUid);
                        isFiltered = true;
                    }
                    if (!isFiltered && not != null && not.contains(consumerUid)) {
                        CliApi.logFlow("ShowApi: Message SKIPPBLED (Exclude check failed)", "from", consumerUid);
                        isFiltered = true;
                    }
                    if (!isFiltered) {
                        Msg msg = new Msg(consumerUid, (byte[])d);
                        this.messages.fire((Object)msg);
                        CliApi.logFlow("ShowApi: Message PROCESSED and fired to console", "from", consumerUid, "dataLength", ((byte[])d).length);
                    }
                });
            });
            ((AFuture)AFuture.run((Executor)CLI_EXECUTOR, () -> ((AetherCloudClient)client).connect()).to(() -> {
                CliApi.logFlow("ShowApi: Client connect successful. Scheduling timeout.", "clientUid", client.getUid());
                RU.schedule((long)waitTime, () -> {
                    CliApi.logFlow("ShowApi: Timeout triggered after %s ms. Starting client destroy.", waitTime);
                    CliApi.completeCliSession(apiDestroyer, client.destroy(true));
                });
                CliApi.logFlow("ShowApi: Timeout scheduled", "waitTimeMs", waitTime);
            })).onError(e -> {
                CliApi.logFlow("ShowApi: Client connect FAILED. Scheduling exit.", "error", e.getMessage());
                RU.schedule((long)10L, () -> {
                    CliApi.logFlow("ShowApi: Client connect failed, completing session.", new Object[0]);
                    apiDestroyer.destroy(true);
                });
            });
            return this.messages;
        }
    }

    @ConsoleMgrCanonical.Doc(value="API for setting properties.")
    public class SetApi {
        private final CliState cliState;

        public SetApi(CliApi this$0, CliState cliState) {
            this.cliState = cliState;
        }

        @ConsoleMgrCanonical.Doc(value="Set or update a user-defined alias for a UUID")
        @ConsoleMgrCanonical.Examples(value={@ConsoleMgrCanonical.Example(value="$exCmd set alias my-friend 3ac93165-3d37-4970-87a6-fa4ee27744e4"), @ConsoleMgrCanonical.Example(value="$exCmd set alias my-server TEST")})
        public void alias(@ConsoleMgrCanonical.Doc(value="The name for the alias") String aliasName, @ConsoleMgrCanonical.Doc(value="The UUID or an existing alias (static or user-defined) to associate with the new alias name. \nKnown static aliases: \n    TEST\u00a0(3ac93165-3d37-4970-87a6-fa4ee27744e4)\n    ROOT\u00a0(ed307ca7-8369-4342-91ee-60c8fc6f9b6b)\n    ANONYMOUS\u00a0(237e2dc0-21a4-4e83-8184-c43052f93b79)\n    (Also supports user aliases. Use 'show aliases' to list them)") UUID uuid) {
            if (aliasName == null || aliasName.isBlank()) {
                throw new IllegalArgumentException("Alias name cannot be empty.");
            }
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null.");
            }
            String upperName = aliasName.toUpperCase();
            if (upperName.equals("TEST") || upperName.equals("ROOT") || upperName.equals("ANONYMOUS")) {
                throw new IllegalArgumentException("Alias name '" + aliasName + "' conflicts with a built-in static alias and cannot be used.");
            }
            this.cliState.addAlias(aliasName, uuid.toString());
            CliApi.logFlow("SetApi: Saved alias '" + aliasName + "' for UUID " + String.valueOf(uuid), new Object[0]);
        }
    }

    @ConsoleMgrCanonical.Doc(value="A container for a received message, holding the sender's address and data.")
    public static class Msg
    implements ToString {
        public final UUID address;
        public final byte[] data;

        public Msg(UUID address, byte[] data) {
            this.address = address;
            this.data = data;
        }

        public String toString() {
            return this.toString2();
        }

        public void toString(AString sb) {
            sb.add((Object)this.address).add(":").add(this.data);
        }
    }
}

