/*
 * Decompiled with CFR 0.152.
 */
package io.aether.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.aether.logger.LNode;
import io.aether.logger.Log;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CliState {
    private static final String STATE_FILE_NAME = ".aether-cli-state.json";
    private final Path stateFilePath;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private StateData data = new StateData();

    public CliState() {
        this.stateFilePath = Paths.get(System.getProperty("user.home"), STATE_FILE_NAME);
    }

    public void load() {
        try {
            if (Files.exists(this.stateFilePath, new LinkOption[0])) {
                String json = Files.readString(this.stateFilePath);
                if (json.isBlank()) {
                    Log.warn((String)"CLI state file is empty, initializing new one.", (LNode[])new LNode[0]);
                    this.save();
                    return;
                }
                StateData loadedData = (StateData)this.gson.fromJson(json, StateData.class);
                if (loadedData != null) {
                    this.data = loadedData;
                    if (this.data.aliases == null) {
                        this.data.aliases = new ConcurrentHashMap<String, String>();
                    }
                    Log.info((String)("Loaded " + this.data.aliases.size() + " user aliases from " + String.valueOf(this.stateFilePath)), (LNode[])new LNode[0]);
                }
            } else {
                Log.info((String)("No CLI state file found, creating a new one at " + String.valueOf(this.stateFilePath)), (LNode[])new LNode[0]);
                this.save();
            }
        }
        catch (Exception e) {
            Log.error((String)("Failed to load CLI state from " + String.valueOf(this.stateFilePath) + ". Error: " + e.getMessage()), (Object[])new Object[0]);
        }
    }

    public synchronized void save() {
        try {
            String json = this.gson.toJson((Object)this.data);
            Files.writeString(this.stateFilePath, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            Log.error((String)("Failed to save CLI state to " + String.valueOf(this.stateFilePath)), (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void addAlias(String alias, String uuid) {
        if (alias == null || alias.isBlank() || uuid == null || uuid.isBlank()) {
            return;
        }
        this.data.aliases.put(alias, uuid);
        this.save();
    }

    public Map<String, String> getAliases() {
        return this.data.aliases;
    }

    public boolean hasAlias(String alias) {
        return this.data.aliases.containsKey(alias);
    }

    public String getUuidForAlias(String alias) {
        return this.data.aliases.get(alias);
    }

    public static class StateData {
        public Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    }
}

