package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface RegistrationRootApi  {
    FastMetaApi<RegistrationRootApi,RegistrationRootApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_139, DataIn in_, RegistrationRootApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_140 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_139,in_);
                        var futureRec_141 = serializeContextVar_139.getFuture(requestId_140);
                        if(futureRec_141 != null) futureRec_141.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_142 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_139,in_);
                        var futureRec_143 = serializeContextVar_139.getFuture(requestId_142);
                        if(futureRec_143 != null) futureRec_143.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        int requestId_144 = in_.readInt();
                        CryptoLib cryptoLib_145;
                        cryptoLib_145=CryptoLib.META.deserialize(serializeContextVar_139,in_);
                        String[] argsNames_146 = new String[] {
                            "cryptoLib"
                        };
                        Object[] argsValues_147 = new Object[] {
                            cryptoLib_145
                        };
                        serializeContextVar_139.invokeLocalMethodBefore("getAsymmetricPublicKey", argsNames_146, argsValues_147);
                        serializeContextVar_139.regLocalFuture();
                        var result_148 = localApi.getAsymmetricPublicKey(cryptoLib_145);
                        serializeContextVar_139.invokeLocalMethodAfter("getAsymmetricPublicKey", result_148, argsNames_146, argsValues_147);
                        result_148.to((v_150)-> {
                            var data_149 = new DataInOut();
                            SignedKey.META.serialize(serializeContextVar_139,v_150,data_149);
                            serializeContextVar_139.sendResultToRemote(requestId_144,data_149.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 4:  {
                        CryptoLib cryptoLib_152;
                        ServerRegistrationApiStream stream_153;
                        cryptoLib_152=CryptoLib.META.deserialize(serializeContextVar_139,in_);
                        stream_153=ServerRegistrationApiStream.META.deserialize(serializeContextVar_139,in_);
                        String[] argsNames_154 = new String[] {
                            "cryptoLib", "stream"
                        };
                        Object[] argsValues_155 = new Object[] {
                            cryptoLib_152, stream_153
                        };
                        serializeContextVar_139.invokeLocalMethodBefore("enter", argsNames_154, argsValues_155);
                        localApi.enter(cryptoLib_152,stream_153);
                        serializeContextVar_139.invokeLocalMethodAfter("enter", null, argsNames_154, argsValues_155);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public RegistrationRootApiRemote makeRemote(FastFutureContext localApi_157) {
            return new RegistrationRootApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_157.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_157;
                    
                }
                @Override public @Command(3) ARFuture<SignedKey> getAsymmetricPublicKey(CryptoLib cryptoLib) {
                    var dataOut_158 = new DataInOut();
                    dataOut_158.writeByte(3);
                    String[] argsNames_160 = new String[] {
                        "cryptoLib"
                    };
                    Object[] argsValues_161 = new Object[] {
                        cryptoLib
                    };
                    var result_159 = ARFuture.<SignedKey>make();
                    localApi_157.invokeRemoteMethodAfter("getAsymmetricPublicKey", result_159, argsNames_160, argsValues_161);
                    var requestId_162 = localApi_157.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_159.done(SignedKey.META.deserialize(localApi_157,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_159.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_158.writeInt(requestId_162);
                    CryptoLib.META.serialize(localApi_157,cryptoLib,dataOut_158);
                    localApi_157.sendToRemote(dataOut_158.toArray());
                    return result_159;
                    
                }
                @Override public @Command(4) void enter(CryptoLib cryptoLib, ServerRegistrationApiStream stream) {
                    var dataOut_163 = new DataInOut();
                    dataOut_163.writeByte(4);
                    String[] argsNames_165 = new String[] {
                        "cryptoLib", "stream"
                    };
                    Object[] argsValues_166 = new Object[] {
                        cryptoLib, stream
                    };
                    localApi_157.invokeRemoteMethodAfter("enter", null, argsNames_165, argsValues_166);
                    CryptoLib.META.serialize(localApi_157,cryptoLib,dataOut_163);
                    ServerRegistrationApiStream.META.serialize(localApi_157,stream,dataOut_163);
                    localApi_157.sendToRemote(dataOut_163.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) ARFuture<SignedKey> getAsymmetricPublicKey(CryptoLib cryptoLib);
    @Command(4) void enter(CryptoLib cryptoLib, ServerRegistrationApiStream stream);
    
}