package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ServerRegistrationApi  {
    FastMetaApi<ServerRegistrationApi,ServerRegistrationApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_74, DataIn in_, ServerRegistrationApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_75 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_74,in_);
                        var futureRec_76 = serializeContextVar_74.getFuture(requestId_75);
                        if(futureRec_76 != null) futureRec_76.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_77 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_74,in_);
                        var futureRec_78 = serializeContextVar_74.getFuture(requestId_77);
                        if(futureRec_78 != null) futureRec_78.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        String salt_80;
                        String suffix_81;
                        int[] passwords_82;
                        UUID parent_83;
                        GlobalApiStream globalApi_84;
                        byte[] stringData_85;
                        var arraySize_86 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        stringData_85=new byte[arraySize_86];
                        in_.read(stringData_85);
                        salt_80=new String(stringData_85);
                        byte[] stringData_87;
                        var arraySize_88 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        stringData_87=new byte[arraySize_88];
                        in_.read(stringData_87);
                        suffix_81=new String(stringData_87);
                        var arraySize_89 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        passwords_82=new int[arraySize_89];
                        for(var forVar_90=0; forVar_90<arraySize_89; forVar_90++) {
                            passwords_82[forVar_90]=in_.readInt();
                            
                        }
                        parent_83=FastMeta.META_UUID.deserialize(serializeContextVar_74,in_);
                        globalApi_84=GlobalApiStream.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_91 = new String[] {
                            "salt", "suffix", "passwords", "parent", "globalApi"
                        };
                        Object[] argsValues_92 = new Object[] {
                            salt_80, suffix_81, passwords_82, parent_83, globalApi_84
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("registration", argsNames_91, argsValues_92);
                        localApi.registration(salt_80,suffix_81,passwords_82,parent_83,globalApi_84);
                        serializeContextVar_74.invokeLocalMethodAfter("registration", null, argsNames_91, argsValues_92);
                        break;
                        
                    }
                    case 4:  {
                        int requestId_93 = in_.readInt();
                        UUID parent_94;
                        PowMethod powMethods_95;
                        parent_94=FastMeta.META_UUID.deserialize(serializeContextVar_74,in_);
                        powMethods_95=PowMethod.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_96 = new String[] {
                            "parent", "powMethods"
                        };
                        Object[] argsValues_97 = new Object[] {
                            parent_94, powMethods_95
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("requestWorkProofData", argsNames_96, argsValues_97);
                        serializeContextVar_74.regLocalFuture();
                        var result_98 = localApi.requestWorkProofData(parent_94,powMethods_95);
                        serializeContextVar_74.invokeLocalMethodAfter("requestWorkProofData", result_98, argsNames_96, argsValues_97);
                        result_98.to((v_100)-> {
                            var data_99 = new DataInOut();
                            WorkProofDTO.META.serialize(serializeContextVar_74,v_100,data_99);
                            serializeContextVar_74.sendResultToRemote(requestId_93,data_99.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 5:  {
                        int requestId_101 = in_.readInt();
                        Cloud serverIds_102;
                        serverIds_102=Cloud.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_103 = new String[] {
                            "serverIds"
                        };
                        Object[] argsValues_104 = new Object[] {
                            serverIds_102
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("resolveServers", argsNames_103, argsValues_104);
                        serializeContextVar_74.regLocalFuture();
                        var result_105 = localApi.resolveServers(serverIds_102);
                        serializeContextVar_74.invokeLocalMethodAfter("resolveServers", result_105, argsNames_103, argsValues_104);
                        result_105.to((v_107)-> {
                            var data_106 = new DataInOut();
                            SerializerPackNumber.INSTANCE.put(data_106,v_107.length);
                            for(var forVar_108:v_107) {
                                ServerDescriptor.META.serialize(serializeContextVar_74,forVar_108,data_106);
                                
                            }
                            serializeContextVar_74.sendResultToRemote(requestId_101,data_106.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 6:  {
                        Key key_110;
                        key_110=Key.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_111 = new String[] {
                            "key"
                        };
                        Object[] argsValues_112 = new Object[] {
                            key_110
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("setReturnKey", argsNames_111, argsValues_112);
                        localApi.setReturnKey(key_110);
                        serializeContextVar_74.invokeLocalMethodAfter("setReturnKey", null, argsNames_111, argsValues_112);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ServerRegistrationApiRemote makeRemote(FastFutureContext localApi_114) {
            return new ServerRegistrationApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_114.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_114;
                    
                }
                @Override public @Command(3) void registration(String salt, String suffix, int[] passwords, UUID parent, GlobalApiStream globalApi) {
                    var dataOut_115 = new DataInOut();
                    dataOut_115.writeByte(3);
                    String[] argsNames_117 = new String[] {
                        "salt", "suffix", "passwords", "parent", "globalApi"
                    };
                    Object[] argsValues_118 = new Object[] {
                        salt, suffix, passwords, parent, globalApi
                    };
                    localApi_114.invokeRemoteMethodAfter("registration", null, argsNames_117, argsValues_118);
                    var stringData_119=salt.getBytes();
                    SerializerPackNumber.INSTANCE.put(dataOut_115,stringData_119.length);
                    dataOut_115.write(stringData_119);
                    var stringData_120=suffix.getBytes();
                    SerializerPackNumber.INSTANCE.put(dataOut_115,stringData_120.length);
                    dataOut_115.write(stringData_120);
                    SerializerPackNumber.INSTANCE.put(dataOut_115,passwords.length);
                    for(var forVar_121:passwords) {
                        dataOut_115.writeInt(forVar_121);
                        
                    }
                    FastMeta.META_UUID.serialize(localApi_114,parent,dataOut_115);
                    GlobalApiStream.META.serialize(localApi_114,globalApi,dataOut_115);
                    localApi_114.sendToRemote(dataOut_115.toArray());
                    
                }
                @Override public @Command(4) ARFuture<WorkProofDTO> requestWorkProofData(UUID parent, PowMethod powMethods) {
                    var dataOut_122 = new DataInOut();
                    dataOut_122.writeByte(4);
                    String[] argsNames_124 = new String[] {
                        "parent", "powMethods"
                    };
                    Object[] argsValues_125 = new Object[] {
                        parent, powMethods
                    };
                    var result_123 = ARFuture.<WorkProofDTO>make();
                    localApi_114.invokeRemoteMethodAfter("requestWorkProofData", result_123, argsNames_124, argsValues_125);
                    var requestId_126 = localApi_114.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_123.done(WorkProofDTO.META.deserialize(localApi_114,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_123.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_122.writeInt(requestId_126);
                    FastMeta.META_UUID.serialize(localApi_114,parent,dataOut_122);
                    PowMethod.META.serialize(localApi_114,powMethods,dataOut_122);
                    localApi_114.sendToRemote(dataOut_122.toArray());
                    return result_123;
                    
                }
                @Override public @Command(5) ARFuture<ServerDescriptor[]> resolveServers(Cloud serverIds) {
                    var dataOut_127 = new DataInOut();
                    dataOut_127.writeByte(5);
                    String[] argsNames_129 = new String[] {
                        "serverIds"
                    };
                    Object[] argsValues_130 = new Object[] {
                        serverIds
                    };
                    var result_128 = ARFuture.<ServerDescriptor[]>make();
                    localApi_114.invokeRemoteMethodAfter("resolveServers", result_128, argsNames_129, argsValues_130);
                    var requestId_131 = localApi_114.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_128.done(ClientServerRegApiMeta.META_ARRAY_ServerDescriptor.deserialize(localApi_114,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_128.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_127.writeInt(requestId_131);
                    Cloud.META.serialize(localApi_114,serverIds,dataOut_127);
                    localApi_114.sendToRemote(dataOut_127.toArray());
                    return result_128;
                    
                }
                @Override public @Command(6) void setReturnKey(Key key) {
                    var dataOut_135 = new DataInOut();
                    dataOut_135.writeByte(6);
                    String[] argsNames_137 = new String[] {
                        "key"
                    };
                    Object[] argsValues_138 = new Object[] {
                        key
                    };
                    localApi_114.invokeRemoteMethodAfter("setReturnKey", null, argsNames_137, argsValues_138);
                    Key.META.serialize(localApi_114,key,dataOut_135);
                    localApi_114.sendToRemote(dataOut_135.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void registration(String salt, String suffix, int[] passwords, UUID parent, GlobalApiStream globalApi);
    @Command(4) ARFuture<WorkProofDTO> requestWorkProofData(UUID parent, PowMethod powMethods);
    @Command(5) ARFuture<ServerDescriptor[]> resolveServers(Cloud serverIds);
    @Command(6) void setReturnKey(Key key);
    
}