package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class ServerRegistrationApiStream implements io.aether.utils.ToString  {
    public static final FastMetaType<ServerRegistrationApiStream> META = new FastMetaType<>()  {
        @Override public void serialize(FastFutureContext ctx, ServerRegistrationApiStream obj, DataOut out)  {
            FastMeta.META_ARRAY_BYTE.serialize(ctx, obj.data, out);
            
        }
        @Override public ServerRegistrationApiStream deserialize(FastFutureContext ctx, DataIn in)  {
            return new ServerRegistrationApiStream(FastMeta.META_ARRAY_BYTE.deserialize(ctx, in));
            
        }
        
    };
    public final byte[] data;
    public ServerRegistrationApiStream(byte[] data)  {
        this.data = data;
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("ServerRegistrationApiStream(");
        sb.add("data[").add(this.data.length).add("]:").add(this.data);
        sb.add(')');
        
    }
    public void accept(FastFutureContext context, BytesConverter provider, ServerRegistrationApi localApi)  {
        byte[] decryptedData = provider.apply(this.data);
        ServerRegistrationApi.META.makeLocal(context, new DataInOutStatic(decryptedData), localApi);
        
    }
    public void accept(FastApiContextLocal<? extends ServerRegistrationApi> context, BytesConverter provider)  {
        accept(context, provider, context.localApi);
        
    }
    public void accept(BytesConverter provider, ServerRegistrationApi localApi)  {
        accept(((FastFutureContextGetter)localApi).getFastFutureContext(),provider,localApi);
        
    }
    public ServerRegistrationApiStream(FastFutureContext context,BytesConverter provider, io.aether.net.fastMeta.RemoteApiFuture<ServerRegistrationApiRemote> remote, AFuture sendFuture)  {
        remote.executeAll(context, sendFuture);
        this.data=provider.apply(context.remoteDataToArray());
        
    }
    public ServerRegistrationApiStream(FastFutureContext context,BytesConverter provider, AConsumer<ServerRegistrationApiRemote> remote)  {
        var api= ServerRegistrationApi.META.makeRemote(context);
        remote.accept(api);
        this.data=provider.apply(context.remoteDataToArray());
        
    }
    public ServerRegistrationApiStream(BytesConverter provider, byte[] remoteData)  {
        this.data=provider.apply(remoteData);
        
    }
    public ServerRegistrationApiStream(FastFutureContextGetter context,BytesConverter provider, AConsumer<ServerRegistrationApiRemote> remote)  {
        this(context.getFastFutureContext(),provider, remote);
        
    }
    
}