package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class GlobalApiStream implements io.aether.utils.ToString  {
    public static final FastMetaType<GlobalApiStream> META = new FastMetaType<>()  {
        @Override public void serialize(FastFutureContext ctx, GlobalApiStream obj, DataOut out)  {
            FastMeta.META_ARRAY_BYTE.serialize(ctx, obj.data, out);
            
        }
        @Override public GlobalApiStream deserialize(FastFutureContext ctx, DataIn in)  {
            return new GlobalApiStream(FastMeta.META_ARRAY_BYTE.deserialize(ctx, in));
            
        }
        
    };
    public final byte[] data;
    public GlobalApiStream(byte[] data)  {
        this.data = data;
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("GlobalApiStream(");
        sb.add("data[").add(this.data.length).add("]:").add(this.data);
        sb.add(')');
        
    }
    public void accept(FastFutureContext context, BytesConverter provider, GlobalRegServerApi localApi)  {
        byte[] decryptedData = provider.apply(this.data);
        GlobalRegServerApi.META.makeLocal(context, new DataInOutStatic(decryptedData), localApi);
        
    }
    public void accept(FastApiContextLocal<? extends GlobalRegServerApi> context, BytesConverter provider)  {
        accept(context, provider, context.localApi);
        
    }
    public void accept(BytesConverter provider, GlobalRegServerApi localApi)  {
        accept(((FastFutureContextGetter)localApi).getFastFutureContext(),provider,localApi);
        
    }
    public GlobalApiStream(FastFutureContext context,BytesConverter provider, io.aether.net.fastMeta.RemoteApiFuture<GlobalRegServerApiRemote> remote, AFuture sendFuture)  {
        remote.executeAll(context, sendFuture);
        this.data=provider.apply(context.remoteDataToArray());
        
    }
    public GlobalApiStream(FastFutureContext context,BytesConverter provider, AConsumer<GlobalRegServerApiRemote> remote)  {
        var api= GlobalRegServerApi.META.makeRemote(context);
        remote.accept(api);
        this.data=provider.apply(context.remoteDataToArray());
        
    }
    public GlobalApiStream(BytesConverter provider, byte[] remoteData)  {
        this.data=provider.apply(remoteData);
        
    }
    public GlobalApiStream(FastFutureContextGetter context,BytesConverter provider, AConsumer<GlobalRegServerApiRemote> remote)  {
        this(context.getFastFutureContext(),provider, remote);
        
    }
    
}