package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class GlobalRegClientApiStream implements io.aether.utils.ToString  {
    public static final FastMetaType<GlobalRegClientApiStream> META = new FastMetaType<>()  {
        @Override public void serialize(FastFutureContext ctx, GlobalRegClientApiStream obj, DataOut out)  {
            FastMeta.META_ARRAY_BYTE.serialize(ctx, obj.data, out);
            
        }
        @Override public GlobalRegClientApiStream deserialize(FastFutureContext ctx, DataIn in)  {
            return new GlobalRegClientApiStream(FastMeta.META_ARRAY_BYTE.deserialize(ctx, in));
            
        }
        
    };
    public final byte[] data;
    public GlobalRegClientApiStream(byte[] data)  {
        this.data = data;
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("GlobalRegClientApiStream(");
        sb.add("data[").add(this.data.length).add("]:").add(this.data);
        sb.add(')');
        
    }
    public void accept(FastFutureContext context, BytesConverter provider, GlobalRegClientApi localApi)  {
        byte[] decryptedData = provider.apply(this.data);
        GlobalRegClientApi.META.makeLocal(context, new DataInOutStatic(decryptedData), localApi);
        
    }
    public void accept(FastApiContextLocal<? extends GlobalRegClientApi> context, BytesConverter provider)  {
        accept(context, provider, context.localApi);
        
    }
    public void accept(BytesConverter provider, GlobalRegClientApi localApi)  {
        accept(((FastFutureContextGetter)localApi).getFastFutureContext(),provider,localApi);
        
    }
    public GlobalRegClientApiStream(FastFutureContext context,BytesConverter provider, io.aether.net.fastMeta.RemoteApiFuture<GlobalRegClientApiRemote> remote, AFuture sendFuture)  {
        remote.executeAll(context, sendFuture);
        this.data=provider.apply(context.remoteDataToArray());
        
    }
    public GlobalRegClientApiStream(FastFutureContext context,BytesConverter provider, AConsumer<GlobalRegClientApiRemote> remote)  {
        var api= GlobalRegClientApi.META.makeRemote(context);
        remote.accept(api);
        this.data=provider.apply(context.remoteDataToArray());
        
    }
    public GlobalRegClientApiStream(BytesConverter provider, byte[] remoteData)  {
        this.data=provider.apply(remoteData);
        
    }
    public GlobalRegClientApiStream(FastFutureContextGetter context,BytesConverter provider, AConsumer<GlobalRegClientApiRemote> remote)  {
        this(context.getFastFutureContext(),provider, remote);
        
    }
    
}