package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface GlobalRegServerApi  {
    FastMetaApi<GlobalRegServerApi,GlobalRegServerApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_48, DataIn in_, GlobalRegServerApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_49 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_48,in_);
                        var futureRec_50 = serializeContextVar_48.getFuture(requestId_49);
                        if(futureRec_50 != null) futureRec_50.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_51 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_48,in_);
                        var futureRec_52 = serializeContextVar_48.getFuture(requestId_51);
                        if(futureRec_52 != null) futureRec_52.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        Key key_54;
                        key_54=Key.META.deserialize(serializeContextVar_48,in_);
                        String[] argsNames_55 = new String[] {
                            "key"
                        };
                        Object[] argsValues_56 = new Object[] {
                            key_54
                        };
                        serializeContextVar_48.invokeLocalMethodBefore("setMasterKey", argsNames_55, argsValues_56);
                        localApi.setMasterKey(key_54);
                        serializeContextVar_48.invokeLocalMethodAfter("setMasterKey", null, argsNames_55, argsValues_56);
                        break;
                        
                    }
                    case 4:  {
                        int requestId_57 = in_.readInt();
                        String[] argsNames_58 = new String[] {
                            
                        };
                        Object[] argsValues_59 = new Object[] {
                            
                        };
                        serializeContextVar_48.invokeLocalMethodBefore("finish", argsNames_58, argsValues_59);
                        serializeContextVar_48.regLocalFuture();
                        var result_60 = localApi.finish();
                        serializeContextVar_48.invokeLocalMethodAfter("finish", result_60, argsNames_58, argsValues_59);
                        result_60.to((v_62)-> {
                            var data_61 = new DataInOut();
                            FinishResult.META.serialize(serializeContextVar_48,v_62,data_61);
                            serializeContextVar_48.sendResultToRemote(requestId_57,data_61.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public GlobalRegServerApiRemote makeRemote(FastFutureContext localApi_64) {
            return new GlobalRegServerApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_64.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_64;
                    
                }
                @Override public @Command(3) void setMasterKey(Key key) {
                    var dataOut_65 = new DataInOut();
                    dataOut_65.writeByte(3);
                    String[] argsNames_67 = new String[] {
                        "key"
                    };
                    Object[] argsValues_68 = new Object[] {
                        key
                    };
                    localApi_64.invokeRemoteMethodAfter("setMasterKey", null, argsNames_67, argsValues_68);
                    Key.META.serialize(localApi_64,key,dataOut_65);
                    localApi_64.sendToRemote(dataOut_65.toArray());
                    
                }
                @Override public @Command(4) ARFuture<FinishResult> finish() {
                    var dataOut_69 = new DataInOut();
                    dataOut_69.writeByte(4);
                    String[] argsNames_71 = new String[] {
                        
                    };
                    Object[] argsValues_72 = new Object[] {
                        
                    };
                    var result_70 = ARFuture.<FinishResult>make();
                    localApi_64.invokeRemoteMethodAfter("finish", result_70, argsNames_71, argsValues_72);
                    var requestId_73 = localApi_64.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_70.done(FinishResult.META.deserialize(localApi_64,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_70.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_69.writeInt(requestId_73);
                    localApi_64.sendToRemote(dataOut_69.toArray());
                    return result_70;
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void setMasterKey(Key key);
    @Command(4) ARFuture<FinishResult> finish();
    
}