package io.aether.api.clientserverregapi;
import java.util.UUID;

import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;

public interface LoginApi  {
    FastMetaApi<LoginApi,LoginApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_338, DataIn in_, LoginApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_339 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_338,in_);
                        var futureRec_340 = serializeContextVar_338.getFuture(requestId_339);
                        if(futureRec_340 != null) futureRec_340.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_341 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_338,in_);
                        var futureRec_342 = serializeContextVar_338.getFuture(requestId_341);
                        if(futureRec_342 != null) futureRec_342.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        int requestId_343 = in_.readInt();
                        String[] argsNames_344 = new String[] {
                            
                        };
                        Object[] argsValues_345 = new Object[] {
                            
                        };
                        serializeContextVar_338.invokeLocalMethodBefore("getTimeUTC", argsNames_344, argsValues_345);
                        serializeContextVar_338.regLocalFuture();
                        var result_346 = localApi.getTimeUTC();
                        serializeContextVar_338.invokeLocalMethodAfter("getTimeUTC", result_346, argsNames_344, argsValues_345);
                        result_346.to((v_348)-> {
                            var data_347 = new DataInOut();
                            data_347.writeLong(v_348);
                            serializeContextVar_338.sendResultToRemote(requestId_343,data_347.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 4:  {
                        UUID uid_350;
                        LoginStream data_351;
                        uid_350=FastMeta.META_UUID.deserialize(serializeContextVar_338,in_);
                        data_351=LoginStream.META.deserialize(serializeContextVar_338,in_);
                        String[] argsNames_352 = new String[] {
                            "uid", "data"
                        };
                        Object[] argsValues_353 = new Object[] {
                            uid_350, data_351
                        };
                        serializeContextVar_338.invokeLocalMethodBefore("loginByUID", argsNames_352, argsValues_353);
                        localApi.loginByUID(uid_350,data_351);
                        serializeContextVar_338.invokeLocalMethodAfter("loginByUID", null, argsNames_352, argsValues_353);
                        break;
                        
                    }
                    case 5:  {
                        UUID alias_355;
                        LoginStream data_356;
                        alias_355=FastMeta.META_UUID.deserialize(serializeContextVar_338,in_);
                        data_356=LoginStream.META.deserialize(serializeContextVar_338,in_);
                        String[] argsNames_357 = new String[] {
                            "alias", "data"
                        };
                        Object[] argsValues_358 = new Object[] {
                            alias_355, data_356
                        };
                        serializeContextVar_338.invokeLocalMethodBefore("loginByAlias", argsNames_357, argsValues_358);
                        localApi.loginByAlias(alias_355,data_356);
                        serializeContextVar_338.invokeLocalMethodAfter("loginByAlias", null, argsNames_357, argsValues_358);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public LoginApiRemote makeRemote(FastFutureContext localApi_360) {
            return new LoginApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_360.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_360;
                    
                }
                @Override public @Command(3) ARFuture<Long> getTimeUTC() {
                    var dataOut_361 = new DataInOut();
                    dataOut_361.writeByte(3);
                    String[] argsNames_363 = new String[] {
                        
                    };
                    Object[] argsValues_364 = new Object[] {
                        
                    };
                    var result_362 = ARFuture.<Long>make();
                    localApi_360.invokeRemoteMethodAfter("getTimeUTC", result_362, argsNames_363, argsValues_364);
                    var requestId_365 = localApi_360.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_362.done(FastMeta.META_LONG.deserialize(localApi_360,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_362.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_361.writeInt(requestId_365);
                    localApi_360.sendToRemote(dataOut_361.toArray());
                    return result_362;
                    
                }
                @Override public @Command(4) void loginByUID(UUID uid, LoginStream data) {
                    var dataOut_366 = new DataInOut();
                    dataOut_366.writeByte(4);
                    String[] argsNames_368 = new String[] {
                        "uid", "data"
                    };
                    Object[] argsValues_369 = new Object[] {
                        uid, data
                    };
                    localApi_360.invokeRemoteMethodAfter("loginByUID", null, argsNames_368, argsValues_369);
                    FastMeta.META_UUID.serialize(localApi_360,uid,dataOut_366);
                    LoginStream.META.serialize(localApi_360,data,dataOut_366);
                    localApi_360.sendToRemote(dataOut_366.toArray());
                    
                }
                @Override public @Command(5) void loginByAlias(UUID alias, LoginStream data) {
                    var dataOut_370 = new DataInOut();
                    dataOut_370.writeByte(5);
                    String[] argsNames_372 = new String[] {
                        "alias", "data"
                    };
                    Object[] argsValues_373 = new Object[] {
                        alias, data
                    };
                    localApi_360.invokeRemoteMethodAfter("loginByAlias", null, argsNames_372, argsValues_373);
                    FastMeta.META_UUID.serialize(localApi_360,alias,dataOut_370);
                    LoginStream.META.serialize(localApi_360,data,dataOut_370);
                    localApi_360.sendToRemote(dataOut_370.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) ARFuture<Long> getTimeUTC();
    @Command(4) void loginByUID(UUID uid, LoginStream data);
    @Command(5) void loginByAlias(UUID alias, LoginStream data);
    
}