package io.aether.api.clientserverregapi;
import io.aether.api.common.*;

import java.util.UUID;

import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;

public interface ServerApiByUid  {
    FastMetaApi<ServerApiByUid,ServerApiByUidRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_381, DataIn in_, ServerApiByUid localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_382 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_381,in_);
                        var futureRec_383 = serializeContextVar_381.getFuture(requestId_382);
                        if(futureRec_383 != null) futureRec_383.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_384 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_381,in_);
                        var futureRec_385 = serializeContextVar_381.getFuture(requestId_384);
                        if(futureRec_385 != null) futureRec_385.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        int requestId_386 = in_.readInt();
                        String[] argsNames_387 = new String[] {
                            
                        };
                        Object[] argsValues_388 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("getBalance", argsNames_387, argsValues_388);
                        serializeContextVar_381.regLocalFuture();
                        var result_389 = localApi.getBalance();
                        serializeContextVar_381.invokeLocalMethodAfter("getBalance", result_389, argsNames_387, argsValues_388);
                        result_389.to((v_391)-> {
                            var data_390 = new DataInOut();
                            data_390.writeLong(v_391);
                            serializeContextVar_381.sendResultToRemote(requestId_386,data_390.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 4:  {
                        int requestId_392 = in_.readInt();
                        UUID uid_393;
                        uid_393=FastMeta.META_UUID.deserialize(serializeContextVar_381,in_);
                        String[] argsNames_394 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_395 = new Object[] {
                            uid_393
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("setParent", argsNames_394, argsValues_395);
                        serializeContextVar_381.regLocalFuture();
                        var result_396 = localApi.setParent(uid_393);
                        serializeContextVar_381.invokeLocalMethodAfter("setParent", result_396, argsNames_394, argsValues_395);
                        result_396.to(()-> {
                            var data_397 = new DataInOut();
                            serializeContextVar_381.sendResultToRemote(requestId_392);
                            
                        }
                        );
                        break;
                        
                    }
                    case 5:  {
                        int requestId_398 = in_.readInt();
                        String[] argsNames_399 = new String[] {
                            
                        };
                        Object[] argsValues_400 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("block", argsNames_399, argsValues_400);
                        serializeContextVar_381.regLocalFuture();
                        var result_401 = localApi.block();
                        serializeContextVar_381.invokeLocalMethodAfter("block", result_401, argsNames_399, argsValues_400);
                        result_401.to(()-> {
                            var data_402 = new DataInOut();
                            serializeContextVar_381.sendResultToRemote(requestId_398);
                            
                        }
                        );
                        break;
                        
                    }
                    case 6:  {
                        int requestId_403 = in_.readInt();
                        String[] argsNames_404 = new String[] {
                            
                        };
                        Object[] argsValues_405 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("getPosition", argsNames_404, argsValues_405);
                        serializeContextVar_381.regLocalFuture();
                        var result_406 = localApi.getPosition();
                        serializeContextVar_381.invokeLocalMethodAfter("getPosition", result_406, argsNames_404, argsValues_405);
                        result_406.to((v_408)-> {
                            var data_407 = new DataInOut();
                            Cloud.META.serialize(serializeContextVar_381,v_408,data_407);
                            serializeContextVar_381.sendResultToRemote(requestId_403,data_407.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 7:  {
                        int requestId_409 = in_.readInt();
                        String[] argsNames_410 = new String[] {
                            
                        };
                        Object[] argsValues_411 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("getParent", argsNames_410, argsValues_411);
                        serializeContextVar_381.regLocalFuture();
                        var result_412 = localApi.getParent();
                        serializeContextVar_381.invokeLocalMethodAfter("getParent", result_412, argsNames_410, argsValues_411);
                        result_412.to((v_414)-> {
                            var data_413 = new DataInOut();
                            FastMeta.META_UUID.serialize(serializeContextVar_381,v_414,data_413);
                            serializeContextVar_381.sendResultToRemote(requestId_409,data_413.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 8:  {
                        int requestId_415 = in_.readInt();
                        String[] argsNames_416 = new String[] {
                            
                        };
                        Object[] argsValues_417 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("getBeneficiary", argsNames_416, argsValues_417);
                        serializeContextVar_381.regLocalFuture();
                        var result_418 = localApi.getBeneficiary();
                        serializeContextVar_381.invokeLocalMethodAfter("getBeneficiary", result_418, argsNames_416, argsValues_417);
                        result_418.to((v_420)-> {
                            var data_419 = new DataInOut();
                            FastMeta.META_UUID.serialize(serializeContextVar_381,v_420,data_419);
                            serializeContextVar_381.sendResultToRemote(requestId_415,data_419.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 9:  {
                        int requestId_421 = in_.readInt();
                        UUID uid_422;
                        uid_422=FastMeta.META_UUID.deserialize(serializeContextVar_381,in_);
                        String[] argsNames_423 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_424 = new Object[] {
                            uid_422
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("setBeneficiary", argsNames_423, argsValues_424);
                        serializeContextVar_381.regLocalFuture();
                        var result_425 = localApi.setBeneficiary(uid_422);
                        serializeContextVar_381.invokeLocalMethodAfter("setBeneficiary", result_425, argsNames_423, argsValues_424);
                        result_425.to(()-> {
                            var data_426 = new DataInOut();
                            serializeContextVar_381.sendResultToRemote(requestId_421);
                            
                        }
                        );
                        break;
                        
                    }
                    case 10:  {
                        int requestId_427 = in_.readInt();
                        String[] argsNames_428 = new String[] {
                            
                        };
                        Object[] argsValues_429 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("getBlockTime", argsNames_428, argsValues_429);
                        serializeContextVar_381.regLocalFuture();
                        var result_430 = localApi.getBlockTime();
                        serializeContextVar_381.invokeLocalMethodAfter("getBlockTime", result_430, argsNames_428, argsValues_429);
                        result_430.to((v_432)-> {
                            var data_431 = new DataInOut();
                            data_431.writeLong(v_432.getTime());
                            serializeContextVar_381.sendResultToRemote(requestId_427,data_431.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 11:  {
                        int requestId_433 = in_.readInt();
                        String[] argsNames_434 = new String[] {
                            
                        };
                        Object[] argsValues_435 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("unblock", argsNames_434, argsValues_435);
                        serializeContextVar_381.regLocalFuture();
                        var result_436 = localApi.unblock();
                        serializeContextVar_381.invokeLocalMethodAfter("unblock", result_436, argsNames_434, argsValues_435);
                        result_436.to(()-> {
                            var data_437 = new DataInOut();
                            serializeContextVar_381.sendResultToRemote(requestId_433);
                            
                        }
                        );
                        break;
                        
                    }
                    case 12:  {
                        int requestId_438 = in_.readInt();
                        String[] argsNames_439 = new String[] {
                            
                        };
                        Object[] argsValues_440 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("createTime", argsNames_439, argsValues_440);
                        serializeContextVar_381.regLocalFuture();
                        var result_441 = localApi.createTime();
                        serializeContextVar_381.invokeLocalMethodAfter("createTime", result_441, argsNames_439, argsValues_440);
                        result_441.to((v_443)-> {
                            var data_442 = new DataInOut();
                            data_442.writeLong(v_443.getTime());
                            serializeContextVar_381.sendResultToRemote(requestId_438,data_442.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 13:  {
                        int requestId_444 = in_.readInt();
                        String[] argsNames_445 = new String[] {
                            
                        };
                        Object[] argsValues_446 = new Object[] {
                            
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("onlineTime", argsNames_445, argsValues_446);
                        serializeContextVar_381.regLocalFuture();
                        var result_447 = localApi.onlineTime();
                        serializeContextVar_381.invokeLocalMethodAfter("onlineTime", result_447, argsNames_445, argsValues_446);
                        result_447.to((v_449)-> {
                            var data_448 = new DataInOut();
                            data_448.writeLong(v_449.getTime());
                            serializeContextVar_381.sendResultToRemote(requestId_444,data_448.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 14:  {
                        int requestId_450 = in_.readInt();
                        long groupId_451;
                        groupId_451=in_.readLong();
                        String[] argsNames_452 = new String[] {
                            "groupId"
                        };
                        Object[] argsValues_453 = new Object[] {
                            groupId_451
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("addAccessGroup", argsNames_452, argsValues_453);
                        serializeContextVar_381.regLocalFuture();
                        var result_454 = localApi.addAccessGroup(groupId_451);
                        serializeContextVar_381.invokeLocalMethodAfter("addAccessGroup", result_454, argsNames_452, argsValues_453);
                        result_454.to((v_456)-> {
                            var data_455 = new DataInOut();
                            data_455.writeByte(v_456?1:0);
                            serializeContextVar_381.sendResultToRemote(requestId_450,data_455.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 15:  {
                        int requestId_457 = in_.readInt();
                        long groupId_458;
                        groupId_458=in_.readLong();
                        String[] argsNames_459 = new String[] {
                            "groupId"
                        };
                        Object[] argsValues_460 = new Object[] {
                            groupId_458
                        };
                        serializeContextVar_381.invokeLocalMethodBefore("removeAccessGroup", argsNames_459, argsValues_460);
                        serializeContextVar_381.regLocalFuture();
                        var result_461 = localApi.removeAccessGroup(groupId_458);
                        serializeContextVar_381.invokeLocalMethodAfter("removeAccessGroup", result_461, argsNames_459, argsValues_460);
                        result_461.to((v_463)-> {
                            var data_462 = new DataInOut();
                            data_462.writeByte(v_463?1:0);
                            serializeContextVar_381.sendResultToRemote(requestId_457,data_462.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ServerApiByUidRemote makeRemote(FastFutureContext localApi_465) {
            return new ServerApiByUidRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_465.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_465;
                    
                }
                @Override public @Command(3) ARFuture<Long> getBalance() {
                    var dataOut_466 = new DataInOut();
                    dataOut_466.writeByte(3);
                    String[] argsNames_468 = new String[] {
                        
                    };
                    Object[] argsValues_469 = new Object[] {
                        
                    };
                    var result_467 = ARFuture.<Long>make();
                    localApi_465.invokeRemoteMethodAfter("getBalance", result_467, argsNames_468, argsValues_469);
                    var requestId_470 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_467.done(FastMeta.META_LONG.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_467.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_466.writeInt(requestId_470);
                    localApi_465.sendToRemote(dataOut_466.toArray());
                    return result_467;
                    
                }
                @Override public @Command(4) AFuture setParent(UUID uid) {
                    var dataOut_471 = new DataInOut();
                    dataOut_471.writeByte(4);
                    String[] argsNames_473 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_474 = new Object[] {
                        uid
                    };
                    var result_472 = AFuture.make();
                    localApi_465.invokeRemoteMethodAfter("setParent", result_472, argsNames_473, argsValues_474);
                    var requestId_475 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_472.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_472.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_471.writeInt(requestId_475);
                    FastMeta.META_UUID.serialize(localApi_465,uid,dataOut_471);
                    localApi_465.sendToRemote(dataOut_471.toArray());
                    return result_472;
                    
                }
                @Override public @Command(5) AFuture block() {
                    var dataOut_476 = new DataInOut();
                    dataOut_476.writeByte(5);
                    String[] argsNames_478 = new String[] {
                        
                    };
                    Object[] argsValues_479 = new Object[] {
                        
                    };
                    var result_477 = AFuture.make();
                    localApi_465.invokeRemoteMethodAfter("block", result_477, argsNames_478, argsValues_479);
                    var requestId_480 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_477.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_477.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_476.writeInt(requestId_480);
                    localApi_465.sendToRemote(dataOut_476.toArray());
                    return result_477;
                    
                }
                @Override public @Command(6) ARFuture<Cloud> getPosition() {
                    var dataOut_481 = new DataInOut();
                    dataOut_481.writeByte(6);
                    String[] argsNames_483 = new String[] {
                        
                    };
                    Object[] argsValues_484 = new Object[] {
                        
                    };
                    var result_482 = ARFuture.<Cloud>make();
                    localApi_465.invokeRemoteMethodAfter("getPosition", result_482, argsNames_483, argsValues_484);
                    var requestId_485 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_482.done(Cloud.META.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_482.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_481.writeInt(requestId_485);
                    localApi_465.sendToRemote(dataOut_481.toArray());
                    return result_482;
                    
                }
                @Override public @Command(7) ARFuture<UUID> getParent() {
                    var dataOut_486 = new DataInOut();
                    dataOut_486.writeByte(7);
                    String[] argsNames_488 = new String[] {
                        
                    };
                    Object[] argsValues_489 = new Object[] {
                        
                    };
                    var result_487 = ARFuture.<UUID>make();
                    localApi_465.invokeRemoteMethodAfter("getParent", result_487, argsNames_488, argsValues_489);
                    var requestId_490 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_487.done(FastMeta.META_UUID.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_487.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_486.writeInt(requestId_490);
                    localApi_465.sendToRemote(dataOut_486.toArray());
                    return result_487;
                    
                }
                @Override public @Command(8) ARFuture<UUID> getBeneficiary() {
                    var dataOut_491 = new DataInOut();
                    dataOut_491.writeByte(8);
                    String[] argsNames_493 = new String[] {
                        
                    };
                    Object[] argsValues_494 = new Object[] {
                        
                    };
                    var result_492 = ARFuture.<UUID>make();
                    localApi_465.invokeRemoteMethodAfter("getBeneficiary", result_492, argsNames_493, argsValues_494);
                    var requestId_495 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_492.done(FastMeta.META_UUID.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_492.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_491.writeInt(requestId_495);
                    localApi_465.sendToRemote(dataOut_491.toArray());
                    return result_492;
                    
                }
                @Override public @Command(9) AFuture setBeneficiary(UUID uid) {
                    var dataOut_496 = new DataInOut();
                    dataOut_496.writeByte(9);
                    String[] argsNames_498 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_499 = new Object[] {
                        uid
                    };
                    var result_497 = AFuture.make();
                    localApi_465.invokeRemoteMethodAfter("setBeneficiary", result_497, argsNames_498, argsValues_499);
                    var requestId_500 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_497.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_497.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_496.writeInt(requestId_500);
                    FastMeta.META_UUID.serialize(localApi_465,uid,dataOut_496);
                    localApi_465.sendToRemote(dataOut_496.toArray());
                    return result_497;
                    
                }
                @Override public @Command(10) ARFuture<java.util.Date> getBlockTime() {
                    var dataOut_501 = new DataInOut();
                    dataOut_501.writeByte(10);
                    String[] argsNames_503 = new String[] {
                        
                    };
                    Object[] argsValues_504 = new Object[] {
                        
                    };
                    var result_502 = ARFuture.<java.util.Date>make();
                    localApi_465.invokeRemoteMethodAfter("getBlockTime", result_502, argsNames_503, argsValues_504);
                    var requestId_505 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_502.done(FastMeta.META_DATE.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_502.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_501.writeInt(requestId_505);
                    localApi_465.sendToRemote(dataOut_501.toArray());
                    return result_502;
                    
                }
                @Override public @Command(11) AFuture unblock() {
                    var dataOut_506 = new DataInOut();
                    dataOut_506.writeByte(11);
                    String[] argsNames_508 = new String[] {
                        
                    };
                    Object[] argsValues_509 = new Object[] {
                        
                    };
                    var result_507 = AFuture.make();
                    localApi_465.invokeRemoteMethodAfter("unblock", result_507, argsNames_508, argsValues_509);
                    var requestId_510 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_507.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_507.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_506.writeInt(requestId_510);
                    localApi_465.sendToRemote(dataOut_506.toArray());
                    return result_507;
                    
                }
                @Override public @Command(12) ARFuture<java.util.Date> createTime() {
                    var dataOut_511 = new DataInOut();
                    dataOut_511.writeByte(12);
                    String[] argsNames_513 = new String[] {
                        
                    };
                    Object[] argsValues_514 = new Object[] {
                        
                    };
                    var result_512 = ARFuture.<java.util.Date>make();
                    localApi_465.invokeRemoteMethodAfter("createTime", result_512, argsNames_513, argsValues_514);
                    var requestId_515 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_512.done(FastMeta.META_DATE.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_512.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_511.writeInt(requestId_515);
                    localApi_465.sendToRemote(dataOut_511.toArray());
                    return result_512;
                    
                }
                @Override public @Command(13) ARFuture<java.util.Date> onlineTime() {
                    var dataOut_516 = new DataInOut();
                    dataOut_516.writeByte(13);
                    String[] argsNames_518 = new String[] {
                        
                    };
                    Object[] argsValues_519 = new Object[] {
                        
                    };
                    var result_517 = ARFuture.<java.util.Date>make();
                    localApi_465.invokeRemoteMethodAfter("onlineTime", result_517, argsNames_518, argsValues_519);
                    var requestId_520 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_517.done(FastMeta.META_DATE.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_517.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_516.writeInt(requestId_520);
                    localApi_465.sendToRemote(dataOut_516.toArray());
                    return result_517;
                    
                }
                @Override public @Command(14) ARFuture<Boolean> addAccessGroup(long groupId) {
                    var dataOut_521 = new DataInOut();
                    dataOut_521.writeByte(14);
                    String[] argsNames_523 = new String[] {
                        "groupId"
                    };
                    Object[] argsValues_524 = new Object[] {
                        groupId
                    };
                    var result_522 = ARFuture.<Boolean>make();
                    localApi_465.invokeRemoteMethodAfter("addAccessGroup", result_522, argsNames_523, argsValues_524);
                    var requestId_525 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_522.done(FastMeta.META_BOOLEAN.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_522.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_521.writeInt(requestId_525);
                    dataOut_521.writeLong(groupId);
                    localApi_465.sendToRemote(dataOut_521.toArray());
                    return result_522;
                    
                }
                @Override public @Command(15) ARFuture<Boolean> removeAccessGroup(long groupId) {
                    var dataOut_526 = new DataInOut();
                    dataOut_526.writeByte(15);
                    String[] argsNames_528 = new String[] {
                        "groupId"
                    };
                    Object[] argsValues_529 = new Object[] {
                        groupId
                    };
                    var result_527 = ARFuture.<Boolean>make();
                    localApi_465.invokeRemoteMethodAfter("removeAccessGroup", result_527, argsNames_528, argsValues_529);
                    var requestId_530 = localApi_465.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_527.done(FastMeta.META_BOOLEAN.deserialize(localApi_465,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_527.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_526.writeInt(requestId_530);
                    dataOut_526.writeLong(groupId);
                    localApi_465.sendToRemote(dataOut_526.toArray());
                    return result_527;
                    
                }
                
            };
            
        }
        
    };
    @Command(3) ARFuture<Long> getBalance();
    @Command(4) AFuture setParent(UUID uid);
    @Command(5) AFuture block();
    @Command(6) ARFuture<Cloud> getPosition();
    @Command(7) ARFuture<UUID> getParent();
    @Command(8) ARFuture<UUID> getBeneficiary();
    @Command(9) AFuture setBeneficiary(UUID uid);
    @Command(10) ARFuture<java.util.Date> getBlockTime();
    @Command(11) AFuture unblock();
    @Command(12) ARFuture<java.util.Date> createTime();
    @Command(13) ARFuture<java.util.Date> onlineTime();
    @Command(14) ARFuture<Boolean> addAccessGroup(long groupId);
    @Command(15) ARFuture<Boolean> removeAccessGroup(long groupId);
    
}