package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class Telemetry implements io.aether.utils.ToString  {
    public abstract int getUtm_id();
    public abstract byte[] getBlob();
    public abstract String getLib_version();
    public abstract String getOs();
    public abstract String getCompiler();
    public abstract int getAetherTypeId();
    public static final FastMetaType<Telemetry> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_0, Telemetry obj_1, DataOut out_2) {
            out_2.writeByte(obj_1.getAetherTypeId());
            switch(obj_1.getAetherTypeId()) {
                case 0: TelemetryCPP.META_BODY.serialize(serializeContextVar_0, (TelemetryCPP)obj_1, out_2);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'Telemetry' with unknown type id " + obj_1.getAetherTypeId());
                
            }
            
        }
        @Override public Telemetry deserialize(FastFutureContext serializeContextVar_0, DataIn in_3) {
            var typeId = in_3.readUByte();
            switch(typeId) {
                case 0: return (Telemetry)TelemetryCPP.META_BODY.deserialize(serializeContextVar_0,in_3);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'Telemetry'");
                
            }
            
        }
        
    };
    public Telemetry()  {
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof Telemetry)) return false;
        Telemetry that = (Telemetry) o;
        return true;
        
    }
    @Override public int hashCode()  {
        return 0;
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("Telemetry(");
        sb.add(')');
        
    }
    
}