package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ClientApiRegUnsafe  {
    FastMetaApi<ClientApiRegUnsafe,ClientApiRegUnsafeRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_14, DataIn in_, ClientApiRegUnsafe localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_15 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_14,in_);
                        var futureRec_16 = serializeContextVar_14.getFuture(requestId_15);
                        if(futureRec_16 != null) futureRec_16.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_17 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_14,in_);
                        var futureRec_18 = serializeContextVar_14.getFuture(requestId_17);
                        if(futureRec_18 != null) futureRec_18.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        ClientApiRegSafeStream stream_20;
                        stream_20=ClientApiRegSafeStream.META.deserialize(serializeContextVar_14,in_);
                        String[] argsNames_21 = new String[] {
                            "stream"
                        };
                        Object[] argsValues_22 = new Object[] {
                            stream_20
                        };
                        serializeContextVar_14.invokeLocalMethodBefore("enter", argsNames_21, argsValues_22);
                        localApi.enter(stream_20);
                        serializeContextVar_14.invokeLocalMethodAfter("enter", null, argsNames_21, argsValues_22);
                        break;
                        
                    }
                    case 4:  {
                        GlobalRegClientApiStream stream_24;
                        stream_24=GlobalRegClientApiStream.META.deserialize(serializeContextVar_14,in_);
                        String[] argsNames_25 = new String[] {
                            "stream"
                        };
                        Object[] argsValues_26 = new Object[] {
                            stream_24
                        };
                        serializeContextVar_14.invokeLocalMethodBefore("enterGlobal", argsNames_25, argsValues_26);
                        localApi.enterGlobal(stream_24);
                        serializeContextVar_14.invokeLocalMethodAfter("enterGlobal", null, argsNames_25, argsValues_26);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ClientApiRegUnsafeRemote makeRemote(FastFutureContext localApi_28) {
            return new ClientApiRegUnsafeRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_28.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_28;
                    
                }
                @Override public @Command(3) void enter(ClientApiRegSafeStream stream) {
                    var dataOut_29 = new DataInOut();
                    dataOut_29.writeByte(3);
                    String[] argsNames_31 = new String[] {
                        "stream"
                    };
                    Object[] argsValues_32 = new Object[] {
                        stream
                    };
                    localApi_28.invokeRemoteMethodAfter("enter", null, argsNames_31, argsValues_32);
                    ClientApiRegSafeStream.META.serialize(localApi_28,stream,dataOut_29);
                    localApi_28.sendToRemote(dataOut_29.toArray());
                    
                }
                @Override public @Command(4) void enterGlobal(GlobalRegClientApiStream stream) {
                    var dataOut_33 = new DataInOut();
                    dataOut_33.writeByte(4);
                    String[] argsNames_35 = new String[] {
                        "stream"
                    };
                    Object[] argsValues_36 = new Object[] {
                        stream
                    };
                    localApi_28.invokeRemoteMethodAfter("enterGlobal", null, argsNames_35, argsValues_36);
                    GlobalRegClientApiStream.META.serialize(localApi_28,stream,dataOut_33);
                    localApi_28.sendToRemote(dataOut_33.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void enter(ClientApiRegSafeStream stream);
    @Command(4) void enterGlobal(GlobalRegClientApiStream stream);
    
}