package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class ClientApiStream implements io.aether.utils.ToString  {
    public static final FastMetaType<ClientApiStream> META = new FastMetaType<>()  {
        @Override public void serialize(FastFutureContext ctx, ClientApiStream obj, DataOut out)  {
            FastMeta.META_ARRAY_BYTE.serialize(ctx, obj.data, out);
            
        }
        @Override public ClientApiStream deserialize(FastFutureContext ctx, DataIn in)  {
            return new ClientApiStream(FastMeta.META_ARRAY_BYTE.deserialize(ctx, in));
            
        }
        
    };
    public final byte[] data;
    public ClientApiStream(byte[] data)  {
        this.data = data;
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("ClientApiStream(");
        sb.add("data[").add(this.data.length).add("]:").add(this.data);
        sb.add(')');
        
    }
    public void accept(FastFutureContext context,ServerApiByUid localApi)  {
        ServerApiByUid.META.makeLocal(context, new DataInOutStatic(this.data), localApi);
        
    }
    public void accept(ServerApiByUid localApi)  {
        accept(((FastFutureContextGetter)localApi).getFastFutureContext(),localApi);
        
    }
    public void accept(FastApiContextLocal<? extends ServerApiByUid> context)  {
        accept(context, context.localApi);
        
    }
    public ClientApiStream(FastFutureContext context,AConsumer<ServerApiByUidRemote> remote)  {
        var api= ServerApiByUid.META.makeRemote(context);
        remote.accept(api);
        this.data=context.remoteDataToArray();
        
    }
    public ClientApiStream(FastFutureContext context,io.aether.net.fastMeta.RemoteApiFuture<ServerApiByUidRemote> remote, AFuture sendFuture)  {
        remote.executeAll(context,sendFuture);
        this.data=context.remoteDataToArray();
        
    }
    public ClientApiStream(FastFutureContextGetter context,AConsumer<ServerApiByUidRemote> remote)  {
        this(context.getFastFutureContext(),remote);
        
    }
    
}