package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ClientApiUnsafe  {
    FastMetaApi<ClientApiUnsafe,ClientApiUnsafeRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_38, DataIn in_, ClientApiUnsafe localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_39 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_38,in_);
                        var futureRec_40 = serializeContextVar_38.getFuture(requestId_39);
                        if(futureRec_40 != null) futureRec_40.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_41 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_38,in_);
                        var futureRec_42 = serializeContextVar_38.getFuture(requestId_41);
                        if(futureRec_42 != null) futureRec_42.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        byte backId_44;
                        LoginClientStream data_45;
                        backId_44=in_.readByte();
                        data_45=LoginClientStream.META.deserialize(serializeContextVar_38,in_);
                        String[] argsNames_46 = new String[] {
                            "backId", "data"
                        };
                        Object[] argsValues_47 = new Object[] {
                            backId_44, data_45
                        };
                        serializeContextVar_38.invokeLocalMethodBefore("sendSafeApiDataMulti", argsNames_46, argsValues_47);
                        localApi.sendSafeApiDataMulti(backId_44,data_45);
                        serializeContextVar_38.invokeLocalMethodAfter("sendSafeApiDataMulti", null, argsNames_46, argsValues_47);
                        break;
                        
                    }
                    case 4:  {
                        LoginClientStream data_49;
                        data_49=LoginClientStream.META.deserialize(serializeContextVar_38,in_);
                        String[] argsNames_50 = new String[] {
                            "data"
                        };
                        Object[] argsValues_51 = new Object[] {
                            data_49
                        };
                        serializeContextVar_38.invokeLocalMethodBefore("sendSafeApiData", argsNames_50, argsValues_51);
                        localApi.sendSafeApiData(data_49);
                        serializeContextVar_38.invokeLocalMethodAfter("sendSafeApiData", null, argsNames_50, argsValues_51);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ClientApiUnsafeRemote makeRemote(FastFutureContext localApi_53) {
            return new ClientApiUnsafeRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_53.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_53;
                    
                }
                @Override public @Command(3) void sendSafeApiDataMulti(byte backId, LoginClientStream data) {
                    var dataOut_54 = new DataInOut();
                    dataOut_54.writeByte(3);
                    String[] argsNames_56 = new String[] {
                        "backId", "data"
                    };
                    Object[] argsValues_57 = new Object[] {
                        backId, data
                    };
                    localApi_53.invokeRemoteMethodAfter("sendSafeApiDataMulti", null, argsNames_56, argsValues_57);
                    dataOut_54.writeByte(backId);
                    LoginClientStream.META.serialize(localApi_53,data,dataOut_54);
                    localApi_53.sendToRemote(dataOut_54.toArray());
                    
                }
                @Override public @Command(4) void sendSafeApiData(LoginClientStream data) {
                    var dataOut_58 = new DataInOut();
                    dataOut_58.writeByte(4);
                    String[] argsNames_60 = new String[] {
                        "data"
                    };
                    Object[] argsValues_61 = new Object[] {
                        data
                    };
                    localApi_53.invokeRemoteMethodAfter("sendSafeApiData", null, argsNames_60, argsValues_61);
                    LoginClientStream.META.serialize(localApi_53,data,dataOut_58);
                    localApi_53.sendToRemote(dataOut_58.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void sendSafeApiDataMulti(byte backId, LoginClientStream data);
    @Command(4) void sendSafeApiData(LoginClientStream data);
    
}