package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface RegistrationRootApi  {
    FastMetaApi<RegistrationRootApi,RegistrationRootApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_133, DataIn in_, RegistrationRootApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_134 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_133,in_);
                        var futureRec_135 = serializeContextVar_133.getFuture(requestId_134);
                        if(futureRec_135 != null) futureRec_135.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_136 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_133,in_);
                        var futureRec_137 = serializeContextVar_133.getFuture(requestId_136);
                        if(futureRec_137 != null) futureRec_137.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        int requestId_138 = in_.readInt();
                        CryptoLib cryptoLib_139;
                        cryptoLib_139=CryptoLib.META.deserialize(serializeContextVar_133,in_);
                        String[] argsNames_140 = new String[] {
                            "cryptoLib"
                        };
                        Object[] argsValues_141 = new Object[] {
                            cryptoLib_139
                        };
                        serializeContextVar_133.invokeLocalMethodBefore("getAsymmetricPublicKey", argsNames_140, argsValues_141);
                        serializeContextVar_133.regLocalFuture();
                        var result_142 = localApi.getAsymmetricPublicKey(cryptoLib_139);
                        serializeContextVar_133.invokeLocalMethodAfter("getAsymmetricPublicKey", result_142, argsNames_140, argsValues_141);
                        result_142.to((v_144)-> {
                            var data_143 = new DataInOut();
                            SignedKey.META.serialize(serializeContextVar_133,v_144,data_143);
                            serializeContextVar_133.sendResultToRemote(requestId_138,data_143.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 4:  {
                        CryptoLib cryptoLib_146;
                        ServerRegistrationApiStream stream_147;
                        cryptoLib_146=CryptoLib.META.deserialize(serializeContextVar_133,in_);
                        stream_147=ServerRegistrationApiStream.META.deserialize(serializeContextVar_133,in_);
                        String[] argsNames_148 = new String[] {
                            "cryptoLib", "stream"
                        };
                        Object[] argsValues_149 = new Object[] {
                            cryptoLib_146, stream_147
                        };
                        serializeContextVar_133.invokeLocalMethodBefore("enter", argsNames_148, argsValues_149);
                        localApi.enter(cryptoLib_146,stream_147);
                        serializeContextVar_133.invokeLocalMethodAfter("enter", null, argsNames_148, argsValues_149);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public RegistrationRootApiRemote makeRemote(FastFutureContext localApi_151) {
            return new RegistrationRootApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_151.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_151;
                    
                }
                @Override public @Command(3) ARFuture<SignedKey> getAsymmetricPublicKey(CryptoLib cryptoLib) {
                    var dataOut_152 = new DataInOut();
                    dataOut_152.writeByte(3);
                    String[] argsNames_154 = new String[] {
                        "cryptoLib"
                    };
                    Object[] argsValues_155 = new Object[] {
                        cryptoLib
                    };
                    var result_153 = ARFuture.<SignedKey>make();
                    localApi_151.invokeRemoteMethodAfter("getAsymmetricPublicKey", result_153, argsNames_154, argsValues_155);
                    var requestId_156 = localApi_151.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_153.done(SignedKey.META.deserialize(localApi_151,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_153.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_152.writeInt(requestId_156);
                    CryptoLib.META.serialize(localApi_151,cryptoLib,dataOut_152);
                    localApi_151.sendToRemote(dataOut_152.toArray());
                    return result_153;
                    
                }
                @Override public @Command(4) void enter(CryptoLib cryptoLib, ServerRegistrationApiStream stream) {
                    var dataOut_157 = new DataInOut();
                    dataOut_157.writeByte(4);
                    String[] argsNames_159 = new String[] {
                        "cryptoLib", "stream"
                    };
                    Object[] argsValues_160 = new Object[] {
                        cryptoLib, stream
                    };
                    localApi_151.invokeRemoteMethodAfter("enter", null, argsNames_159, argsValues_160);
                    CryptoLib.META.serialize(localApi_151,cryptoLib,dataOut_157);
                    ServerRegistrationApiStream.META.serialize(localApi_151,stream,dataOut_157);
                    localApi_151.sendToRemote(dataOut_157.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) ARFuture<SignedKey> getAsymmetricPublicKey(CryptoLib cryptoLib);
    @Command(4) void enter(CryptoLib cryptoLib, ServerRegistrationApiStream stream);
    
}