package io.aether.api.clientserverregapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ServerRegistrationApi  {
    FastMetaApi<ServerRegistrationApi,ServerRegistrationApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_74, DataIn in_, ServerRegistrationApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_75 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_74,in_);
                        var futureRec_76 = serializeContextVar_74.getFuture(requestId_75);
                        if(futureRec_76 != null) futureRec_76.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_77 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_74,in_);
                        var futureRec_78 = serializeContextVar_74.getFuture(requestId_77);
                        if(futureRec_78 != null) futureRec_78.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        String salt_80;
                        String suffix_81;
                        int[] passwords_82;
                        UUID parent_83;
                        Key returnKey_84;
                        GlobalApiStream globalApi_85;
                        byte[] stringData_86;
                        var arraySize_87 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        stringData_86=new byte[arraySize_87];
                        in_.read(stringData_86);
                        salt_80=new String(stringData_86);
                        byte[] stringData_88;
                        var arraySize_89 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        stringData_88=new byte[arraySize_89];
                        in_.read(stringData_88);
                        suffix_81=new String(stringData_88);
                        var arraySize_90 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        passwords_82=new int[arraySize_90];
                        for(var forVar_91=0; forVar_91<arraySize_90; forVar_91++) {
                            passwords_82[forVar_91]=in_.readInt();
                            
                        }
                        parent_83=FastMeta.META_UUID.deserialize(serializeContextVar_74,in_);
                        returnKey_84=Key.META.deserialize(serializeContextVar_74,in_);
                        globalApi_85=GlobalApiStream.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_92 = new String[] {
                            "salt", "suffix", "passwords", "parent", "returnKey", "globalApi"
                        };
                        Object[] argsValues_93 = new Object[] {
                            salt_80, suffix_81, passwords_82, parent_83, returnKey_84, globalApi_85
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("registration", argsNames_92, argsValues_93);
                        localApi.registration(salt_80,suffix_81,passwords_82,parent_83,returnKey_84,globalApi_85);
                        serializeContextVar_74.invokeLocalMethodAfter("registration", null, argsNames_92, argsValues_93);
                        break;
                        
                    }
                    case 4:  {
                        int requestId_94 = in_.readInt();
                        UUID parent_95;
                        PowMethod powMethods_96;
                        Key returnKey_97;
                        parent_95=FastMeta.META_UUID.deserialize(serializeContextVar_74,in_);
                        powMethods_96=PowMethod.META.deserialize(serializeContextVar_74,in_);
                        returnKey_97=Key.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_98 = new String[] {
                            "parent", "powMethods", "returnKey"
                        };
                        Object[] argsValues_99 = new Object[] {
                            parent_95, powMethods_96, returnKey_97
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("requestWorkProofData", argsNames_98, argsValues_99);
                        serializeContextVar_74.regLocalFuture();
                        var result_100 = localApi.requestWorkProofData(parent_95,powMethods_96,returnKey_97);
                        serializeContextVar_74.invokeLocalMethodAfter("requestWorkProofData", result_100, argsNames_98, argsValues_99);
                        result_100.to((v_102)-> {
                            var data_101 = new DataInOut();
                            WorkProofDTO.META.serialize(serializeContextVar_74,v_102,data_101);
                            serializeContextVar_74.sendResultToRemote(requestId_94,data_101.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 5:  {
                        int requestId_103 = in_.readInt();
                        Cloud serverIds_104;
                        serverIds_104=Cloud.META.deserialize(serializeContextVar_74,in_);
                        String[] argsNames_105 = new String[] {
                            "serverIds"
                        };
                        Object[] argsValues_106 = new Object[] {
                            serverIds_104
                        };
                        serializeContextVar_74.invokeLocalMethodBefore("resolveServers", argsNames_105, argsValues_106);
                        serializeContextVar_74.regLocalFuture();
                        var result_107 = localApi.resolveServers(serverIds_104);
                        serializeContextVar_74.invokeLocalMethodAfter("resolveServers", result_107, argsNames_105, argsValues_106);
                        result_107.to((v_109)-> {
                            var data_108 = new DataInOut();
                            SerializerPackNumber.INSTANCE.put(data_108,v_109.length);
                            for(var forVar_110:v_109) {
                                ServerDescriptor.META.serialize(serializeContextVar_74,forVar_110,data_108);
                                
                            }
                            serializeContextVar_74.sendResultToRemote(requestId_103,data_108.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ServerRegistrationApiRemote makeRemote(FastFutureContext localApi_112) {
            return new ServerRegistrationApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_112.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_112;
                    
                }
                @Override public @Command(3) void registration(String salt, String suffix, int[] passwords, UUID parent, Key returnKey, GlobalApiStream globalApi) {
                    var dataOut_113 = new DataInOut();
                    dataOut_113.writeByte(3);
                    String[] argsNames_115 = new String[] {
                        "salt", "suffix", "passwords", "parent", "returnKey", "globalApi"
                    };
                    Object[] argsValues_116 = new Object[] {
                        salt, suffix, passwords, parent, returnKey, globalApi
                    };
                    localApi_112.invokeRemoteMethodAfter("registration", null, argsNames_115, argsValues_116);
                    var stringData_117=salt.getBytes();
                    SerializerPackNumber.INSTANCE.put(dataOut_113,stringData_117.length);
                    dataOut_113.write(stringData_117);
                    var stringData_118=suffix.getBytes();
                    SerializerPackNumber.INSTANCE.put(dataOut_113,stringData_118.length);
                    dataOut_113.write(stringData_118);
                    SerializerPackNumber.INSTANCE.put(dataOut_113,passwords.length);
                    for(var forVar_119:passwords) {
                        dataOut_113.writeInt(forVar_119);
                        
                    }
                    FastMeta.META_UUID.serialize(localApi_112,parent,dataOut_113);
                    Key.META.serialize(localApi_112,returnKey,dataOut_113);
                    GlobalApiStream.META.serialize(localApi_112,globalApi,dataOut_113);
                    localApi_112.sendToRemote(dataOut_113.toArray());
                    
                }
                @Override public @Command(4) ARFuture<WorkProofDTO> requestWorkProofData(UUID parent, PowMethod powMethods, Key returnKey) {
                    var dataOut_120 = new DataInOut();
                    dataOut_120.writeByte(4);
                    String[] argsNames_122 = new String[] {
                        "parent", "powMethods", "returnKey"
                    };
                    Object[] argsValues_123 = new Object[] {
                        parent, powMethods, returnKey
                    };
                    var result_121 = ARFuture.<WorkProofDTO>make();
                    localApi_112.invokeRemoteMethodAfter("requestWorkProofData", result_121, argsNames_122, argsValues_123);
                    var requestId_124 = localApi_112.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_121.done(WorkProofDTO.META.deserialize(localApi_112,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_121.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_120.writeInt(requestId_124);
                    FastMeta.META_UUID.serialize(localApi_112,parent,dataOut_120);
                    PowMethod.META.serialize(localApi_112,powMethods,dataOut_120);
                    Key.META.serialize(localApi_112,returnKey,dataOut_120);
                    localApi_112.sendToRemote(dataOut_120.toArray());
                    return result_121;
                    
                }
                @Override public @Command(5) ARFuture<ServerDescriptor[]> resolveServers(Cloud serverIds) {
                    var dataOut_125 = new DataInOut();
                    dataOut_125.writeByte(5);
                    String[] argsNames_127 = new String[] {
                        "serverIds"
                    };
                    Object[] argsValues_128 = new Object[] {
                        serverIds
                    };
                    var result_126 = ARFuture.<ServerDescriptor[]>make();
                    localApi_112.invokeRemoteMethodAfter("resolveServers", result_126, argsNames_127, argsValues_128);
                    var requestId_129 = localApi_112.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_126.done(ClientServerRegApiMeta.META_ARRAY_ServerDescriptor.deserialize(localApi_112,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_126.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_125.writeInt(requestId_129);
                    Cloud.META.serialize(localApi_112,serverIds,dataOut_125);
                    localApi_112.sendToRemote(dataOut_125.toArray());
                    return result_126;
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void registration(String salt, String suffix, int[] passwords, UUID parent, Key returnKey, GlobalApiStream globalApi);
    @Command(4) ARFuture<WorkProofDTO> requestWorkProofData(UUID parent, PowMethod powMethods, Key returnKey);
    @Command(5) ARFuture<ServerDescriptor[]> resolveServers(Cloud serverIds);
    
}