/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.clientserverapi;

import io.aether.api.clientserverapi.Telemetry;
import io.aether.net.fastMeta.DeserializerPackNumber;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaType;
import io.aether.net.fastMeta.SerializerPackNumber;
import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import java.util.Arrays;
import java.util.Objects;

public class TelemetryCPP
extends Telemetry
implements ToString {
    public static final FastMetaType<TelemetryCPP> META_BODY = new FastMetaType<TelemetryCPP>(){

        public void serialize(FastFutureContext serializeContextVar_4, TelemetryCPP obj_5, DataOut out_6) {
            out_6.writeInt(obj_5.utm_id);
            SerializerPackNumber.INSTANCE.put(out_6, obj_5.blob.length);
            out_6.write(obj_5.blob);
            byte[] stringData_8 = obj_5.lib_version.getBytes();
            SerializerPackNumber.INSTANCE.put(out_6, stringData_8.length);
            out_6.write(stringData_8);
            byte[] stringData_9 = obj_5.os.getBytes();
            SerializerPackNumber.INSTANCE.put(out_6, stringData_9.length);
            out_6.write(stringData_9);
            byte[] stringData_10 = obj_5.compiler.getBytes();
            SerializerPackNumber.INSTANCE.put(out_6, stringData_10.length);
            out_6.write(stringData_10);
        }

        public TelemetryCPP deserialize(FastFutureContext serializeContextVar_4, DataIn in_7) {
            int utm_id_11 = in_7.readInt();
            int arraySize_16 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            byte[] blob_12 = new byte[arraySize_16];
            in_7.read(blob_12);
            int arraySize_18 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            byte[] stringData_17 = new byte[arraySize_18];
            in_7.read(stringData_17);
            String lib_version_13 = new String(stringData_17);
            int arraySize_20 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            byte[] stringData_19 = new byte[arraySize_20];
            in_7.read(stringData_19);
            String os_14 = new String(stringData_19);
            int arraySize_22 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            byte[] stringData_21 = new byte[arraySize_22];
            in_7.read(stringData_21);
            String compiler_15 = new String(stringData_21);
            return new TelemetryCPP(utm_id_11, blob_12, lib_version_13, os_14, compiler_15);
        }
    };
    public static final FastMetaType<TelemetryCPP> META = new FastMetaType<TelemetryCPP>(){

        public void serialize(FastFutureContext serializeContextVar_23, TelemetryCPP obj_24, DataOut out_25) {
            META_BODY.serialize(serializeContextVar_23, (Object)obj_24, out_25);
        }

        public TelemetryCPP deserialize(FastFutureContext serializeContextVar_23, DataIn in_26) {
            return (TelemetryCPP)META_BODY.deserialize(serializeContextVar_23, in_26);
        }
    };
    protected final int utm_id;
    protected final byte[] blob;
    protected final String lib_version;
    protected final String os;
    protected final String compiler;

    @Override
    public int getAetherTypeId() {
        return 1;
    }

    public TelemetryCPP(int utm_id, byte[] blob, String lib_version, String os, String compiler) {
        if (blob == null) {
            throw new NullPointerException("Field 'blob' cannot be null.");
        }
        this.utm_id = utm_id;
        this.blob = blob;
        this.lib_version = lib_version;
        this.os = os;
        this.compiler = compiler;
    }

    @Override
    public int getUtm_id() {
        return this.utm_id;
    }

    @Override
    public byte[] getBlob() {
        return this.blob;
    }

    public boolean blobContains(byte el) {
        return ByteSet.of((byte[])this.blob).contains(el);
    }

    @Override
    public String getLib_version() {
        return this.lib_version;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    @Override
    public String getCompiler() {
        return this.compiler;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TelemetryCPP)) {
            return false;
        }
        TelemetryCPP that = (TelemetryCPP)o;
        return Objects.equals(this.utm_id, that.utm_id) && Arrays.equals(this.blob, that.blob) && Objects.equals(this.lib_version, that.lib_version) && Objects.equals(this.os, that.os) && Objects.equals(this.compiler, that.compiler);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.utm_id, Arrays.hashCode(this.blob), this.lib_version, this.os, this.compiler);
    }

    @Override
    public String toString() {
        return this.toString2();
    }

    @Override
    public void toString(AString sb) {
        sb.add("TelemetryCPP(");
        sb.add("utm_id:");
        sb.add(this.utm_id);
        sb.add(", ");
        sb.add("blob:");
        sb.add(this.blob);
        sb.add(", ");
        sb.add("lib_version:");
        sb.add(this.lib_version);
        sb.add(", ");
        sb.add("os:");
        sb.add(this.os);
        sb.add(", ");
        sb.add("compiler:");
        sb.add(this.compiler);
        sb.add(')');
    }
}

