package io.aether.api.clientserverapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface AuthorizedApi  {
    FastMetaApi<AuthorizedApi,AuthorizedApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_150, DataIn in_, AuthorizedApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_151 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_150,in_);
                        var futureRec_152 = serializeContextVar_150.getFuture(requestId_151);
                        if(futureRec_152 != null) futureRec_152.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_153 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_150,in_);
                        var futureRec_154 = serializeContextVar_150.getFuture(requestId_153);
                        if(futureRec_154 != null) futureRec_154.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        byte id_156;
                        id_156=in_.readByte();
                        String[] argsNames_157 = new String[] {
                            "id"
                        };
                        Object[] argsValues_158 = new Object[] {
                            id_156
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("backId", argsNames_157, argsValues_158);
                        localApi.backId(id_156);
                        serializeContextVar_150.invokeLocalMethodAfter("backId", null, argsNames_157, argsValues_158);
                        break;
                        
                    }
                    case 4:  {
                        int requestId_159 = in_.readInt();
                        long nextConnectMsDuration_160;
                        nextConnectMsDuration_160=in_.readLong();
                        String[] argsNames_161 = new String[] {
                            "nextConnectMsDuration"
                        };
                        Object[] argsValues_162 = new Object[] {
                            nextConnectMsDuration_160
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("ping", argsNames_161, argsValues_162);
                        serializeContextVar_150.regLocalFuture();
                        var result_163 = localApi.ping(nextConnectMsDuration_160);
                        serializeContextVar_150.invokeLocalMethodAfter("ping", result_163, argsNames_161, argsValues_162);
                        result_163.to(()-> {
                            var data_164 = new DataInOut();
                            serializeContextVar_150.sendResultToRemote(requestId_159);
                            
                        }
                        );
                        break;
                        
                    }
                    case 5:  {
                        UUID uid_166;
                        ClientApiStream stream_167;
                        uid_166=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        stream_167=ClientApiStream.META.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_168 = new String[] {
                            "uid", "stream"
                        };
                        Object[] argsValues_169 = new Object[] {
                            uid_166, stream_167
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("client", argsNames_168, argsValues_169);
                        localApi.client(uid_166,stream_167);
                        serializeContextVar_150.invokeLocalMethodAfter("client", null, argsNames_168, argsValues_169);
                        break;
                        
                    }
                    case 6:  {
                        Message msg_171;
                        msg_171=Message.META.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_172 = new String[] {
                            "msg"
                        };
                        Object[] argsValues_173 = new Object[] {
                            msg_171
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("sendMessage", argsNames_172, argsValues_173);
                        localApi.sendMessage(msg_171);
                        serializeContextVar_150.invokeLocalMethodAfter("sendMessage", null, argsNames_172, argsValues_173);
                        break;
                        
                    }
                    case 7:  {
                        Message[] msg_175;
                        var arraySize_176 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        msg_175=new Message[arraySize_176];
                        for(var forVar_177=0; forVar_177<arraySize_176; forVar_177++) {
                            msg_175[forVar_177]=Message.META.deserialize(serializeContextVar_150,in_);
                            
                        }
                        String[] argsNames_178 = new String[] {
                            "msg"
                        };
                        Object[] argsValues_179 = new Object[] {
                            msg_175
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("sendMessages", argsNames_178, argsValues_179);
                        localApi.sendMessages(msg_175);
                        serializeContextVar_150.invokeLocalMethodAfter("sendMessages", null, argsNames_178, argsValues_179);
                        break;
                        
                    }
                    case 8:  {
                        int requestId_180 = in_.readInt();
                        UUID owner_181;
                        UUID[] uids_182;
                        owner_181=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        var arraySize_183 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        uids_182=new UUID[arraySize_183];
                        for(var forVar_184=0; forVar_184<arraySize_183; forVar_184++) {
                            uids_182[forVar_184]=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                            
                        }
                        String[] argsNames_185 = new String[] {
                            "owner", "uids"
                        };
                        Object[] argsValues_186 = new Object[] {
                            owner_181, uids_182
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("createAccessGroup", argsNames_185, argsValues_186);
                        serializeContextVar_150.regLocalFuture();
                        var result_187 = localApi.createAccessGroup(owner_181,uids_182);
                        serializeContextVar_150.invokeLocalMethodAfter("createAccessGroup", result_187, argsNames_185, argsValues_186);
                        result_187.to((v_189)-> {
                            var data_188 = new DataInOut();
                            data_188.writeLong(v_189);
                            serializeContextVar_150.sendResultToRemote(requestId_180,data_188.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 9:  {
                        int requestId_190 = in_.readInt();
                        long groupId_191;
                        UUID uid_192;
                        groupId_191=in_.readLong();
                        uid_192=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_193 = new String[] {
                            "groupId", "uid"
                        };
                        Object[] argsValues_194 = new Object[] {
                            groupId_191, uid_192
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("addToAccessGroup", argsNames_193, argsValues_194);
                        serializeContextVar_150.regLocalFuture();
                        var result_195 = localApi.addToAccessGroup(groupId_191,uid_192);
                        serializeContextVar_150.invokeLocalMethodAfter("addToAccessGroup", result_195, argsNames_193, argsValues_194);
                        result_195.to((v_197)-> {
                            var data_196 = new DataInOut();
                            data_196.writeByte(v_197?1:0);
                            serializeContextVar_150.sendResultToRemote(requestId_190,data_196.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 10:  {
                        int requestId_198 = in_.readInt();
                        long groupId_199;
                        UUID uid_200;
                        groupId_199=in_.readLong();
                        uid_200=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_201 = new String[] {
                            "groupId", "uid"
                        };
                        Object[] argsValues_202 = new Object[] {
                            groupId_199, uid_200
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("removeFromAccessGroup", argsNames_201, argsValues_202);
                        serializeContextVar_150.regLocalFuture();
                        var result_203 = localApi.removeFromAccessGroup(groupId_199,uid_200);
                        serializeContextVar_150.invokeLocalMethodAfter("removeFromAccessGroup", result_203, argsNames_201, argsValues_202);
                        result_203.to((v_205)-> {
                            var data_204 = new DataInOut();
                            data_204.writeByte(v_205?1:0);
                            serializeContextVar_150.sendResultToRemote(requestId_198,data_204.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 11:  {
                        int requestId_206 = in_.readInt();
                        UUID uid_207;
                        uid_207=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_208 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_209 = new Object[] {
                            uid_207
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("checkAccessForSendMessage", argsNames_208, argsValues_209);
                        serializeContextVar_150.regLocalFuture();
                        var result_210 = localApi.checkAccessForSendMessage(uid_207);
                        serializeContextVar_150.invokeLocalMethodAfter("checkAccessForSendMessage", result_210, argsNames_208, argsValues_209);
                        result_210.to(()-> {
                            var data_211 = new DataInOut();
                            serializeContextVar_150.sendResultToRemote(requestId_206);
                            
                        }
                        );
                        break;
                        
                    }
                    case 12:  {
                        short[] sid_213;
                        var arraySize_214 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        sid_213=new short[arraySize_214];
                        for(var forVar_215=0; forVar_215<arraySize_214; forVar_215++) {
                            sid_213[forVar_215]=in_.readShort();
                            
                        }
                        String[] argsNames_216 = new String[] {
                            "sid"
                        };
                        Object[] argsValues_217 = new Object[] {
                            sid_213
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("resolverServers", argsNames_216, argsValues_217);
                        localApi.resolverServers(sid_213);
                        serializeContextVar_150.invokeLocalMethodAfter("resolverServers", null, argsNames_216, argsValues_217);
                        break;
                        
                    }
                    case 13:  {
                        UUID[] uids_219;
                        var arraySize_220 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        uids_219=new UUID[arraySize_220];
                        for(var forVar_221=0; forVar_221<arraySize_220; forVar_221++) {
                            uids_219[forVar_221]=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                            
                        }
                        String[] argsNames_222 = new String[] {
                            "uids"
                        };
                        Object[] argsValues_223 = new Object[] {
                            uids_219
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("resolverClouds", argsNames_222, argsValues_223);
                        localApi.resolverClouds(uids_219);
                        serializeContextVar_150.invokeLocalMethodAfter("resolverClouds", null, argsNames_222, argsValues_223);
                        break;
                        
                    }
                    case 14:  {
                        int requestId_224 = in_.readInt();
                        UUID uid_225;
                        uid_225=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_226 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_227 = new Object[] {
                            uid_225
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("getAccessGroups", argsNames_226, argsValues_227);
                        serializeContextVar_150.regLocalFuture();
                        var result_228 = localApi.getAccessGroups(uid_225);
                        serializeContextVar_150.invokeLocalMethodAfter("getAccessGroups", result_228, argsNames_226, argsValues_227);
                        result_228.to((v_230)-> {
                            var data_229 = new DataInOut();
                            SerializerPackNumber.INSTANCE.put(data_229,v_230.length);
                            for(var forVar_231:v_230) {
                                data_229.writeLong(forVar_231);
                                
                            }
                            serializeContextVar_150.sendResultToRemote(requestId_224,data_229.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 15:  {
                        int requestId_232 = in_.readInt();
                        long groupId_233;
                        groupId_233=in_.readLong();
                        String[] argsNames_234 = new String[] {
                            "groupId"
                        };
                        Object[] argsValues_235 = new Object[] {
                            groupId_233
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("getAccessGroup", argsNames_234, argsValues_235);
                        serializeContextVar_150.regLocalFuture();
                        var result_236 = localApi.getAccessGroup(groupId_233);
                        serializeContextVar_150.invokeLocalMethodAfter("getAccessGroup", result_236, argsNames_234, argsValues_235);
                        result_236.to((v_238)-> {
                            var data_237 = new DataInOut();
                            AccessGroup.META.serialize(serializeContextVar_150,v_238,data_237);
                            serializeContextVar_150.sendResultToRemote(requestId_232,data_237.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 16:  {
                        int requestId_239 = in_.readInt();
                        UUID uid_240;
                        uid_240=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_241 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_242 = new Object[] {
                            uid_240
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("getAllAccessedClients", argsNames_241, argsValues_242);
                        serializeContextVar_150.regLocalFuture();
                        var result_243 = localApi.getAllAccessedClients(uid_240);
                        serializeContextVar_150.invokeLocalMethodAfter("getAllAccessedClients", result_243, argsNames_241, argsValues_242);
                        result_243.to((v_245)-> {
                            var data_244 = new DataInOut();
                            SerializerPackNumber.INSTANCE.put(data_244,v_245.length);
                            for(var forVar_246:v_245) {
                                FastMeta.META_UUID.serialize(serializeContextVar_150,forVar_246,data_244);
                                
                            }
                            serializeContextVar_150.sendResultToRemote(requestId_239,data_244.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 17:  {
                        int requestId_247 = in_.readInt();
                        UUID uid1_248;
                        UUID uid2_249;
                        uid1_248=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        uid2_249=FastMeta.META_UUID.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_250 = new String[] {
                            "uid1", "uid2"
                        };
                        Object[] argsValues_251 = new Object[] {
                            uid1_248, uid2_249
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("checkAccessForSendMessage2", argsNames_250, argsValues_251);
                        serializeContextVar_150.regLocalFuture();
                        var result_252 = localApi.checkAccessForSendMessage2(uid1_248,uid2_249);
                        serializeContextVar_150.invokeLocalMethodAfter("checkAccessForSendMessage2", result_252, argsNames_250, argsValues_251);
                        result_252.to((v_254)-> {
                            var data_253 = new DataInOut();
                            data_253.writeByte(v_254?1:0);
                            serializeContextVar_150.sendResultToRemote(requestId_247,data_253.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 18:  {
                        Telemetry telemetry_256;
                        telemetry_256=Telemetry.META.deserialize(serializeContextVar_150,in_);
                        String[] argsNames_257 = new String[] {
                            "telemetry"
                        };
                        Object[] argsValues_258 = new Object[] {
                            telemetry_256
                        };
                        serializeContextVar_150.invokeLocalMethodBefore("sendTelemetry", argsNames_257, argsValues_258);
                        localApi.sendTelemetry(telemetry_256);
                        serializeContextVar_150.invokeLocalMethodAfter("sendTelemetry", null, argsNames_257, argsValues_258);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public AuthorizedApiRemote makeRemote(FastFutureContext localApi_260) {
            return new AuthorizedApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_260.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_260;
                    
                }
                @Override public @Command(3) void backId(byte id) {
                    var dataOut_261 = new DataInOut();
                    dataOut_261.writeByte(3);
                    String[] argsNames_263 = new String[] {
                        "id"
                    };
                    Object[] argsValues_264 = new Object[] {
                        id
                    };
                    localApi_260.invokeRemoteMethodAfter("backId", null, argsNames_263, argsValues_264);
                    dataOut_261.writeByte(id);
                    localApi_260.sendToRemote(dataOut_261.toArray());
                    
                }
                @Override public @Command(4) AFuture ping(long nextConnectMsDuration) {
                    var dataOut_265 = new DataInOut();
                    dataOut_265.writeByte(4);
                    String[] argsNames_267 = new String[] {
                        "nextConnectMsDuration"
                    };
                    Object[] argsValues_268 = new Object[] {
                        nextConnectMsDuration
                    };
                    var result_266 = AFuture.make();
                    localApi_260.invokeRemoteMethodAfter("ping", result_266, argsNames_267, argsValues_268);
                    var requestId_269 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_266.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_266.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_265.writeInt(requestId_269);
                    dataOut_265.writeLong(nextConnectMsDuration);
                    localApi_260.sendToRemote(dataOut_265.toArray());
                    return result_266;
                    
                }
                @Override public @Command(5) void client(UUID uid, ClientApiStream stream) {
                    var dataOut_270 = new DataInOut();
                    dataOut_270.writeByte(5);
                    String[] argsNames_272 = new String[] {
                        "uid", "stream"
                    };
                    Object[] argsValues_273 = new Object[] {
                        uid, stream
                    };
                    localApi_260.invokeRemoteMethodAfter("client", null, argsNames_272, argsValues_273);
                    FastMeta.META_UUID.serialize(localApi_260,uid,dataOut_270);
                    ClientApiStream.META.serialize(localApi_260,stream,dataOut_270);
                    localApi_260.sendToRemote(dataOut_270.toArray());
                    
                }
                @Override public @Command(6) void sendMessage(Message msg) {
                    var dataOut_274 = new DataInOut();
                    dataOut_274.writeByte(6);
                    String[] argsNames_276 = new String[] {
                        "msg"
                    };
                    Object[] argsValues_277 = new Object[] {
                        msg
                    };
                    localApi_260.invokeRemoteMethodAfter("sendMessage", null, argsNames_276, argsValues_277);
                    Message.META.serialize(localApi_260,msg,dataOut_274);
                    localApi_260.sendToRemote(dataOut_274.toArray());
                    
                }
                @Override public @Command(7) void sendMessages(Message[] msg) {
                    var dataOut_278 = new DataInOut();
                    dataOut_278.writeByte(7);
                    String[] argsNames_280 = new String[] {
                        "msg"
                    };
                    Object[] argsValues_281 = new Object[] {
                        msg
                    };
                    localApi_260.invokeRemoteMethodAfter("sendMessages", null, argsNames_280, argsValues_281);
                    SerializerPackNumber.INSTANCE.put(dataOut_278,msg.length);
                    for(var forVar_282:msg) {
                        Message.META.serialize(localApi_260,forVar_282,dataOut_278);
                        
                    }
                    localApi_260.sendToRemote(dataOut_278.toArray());
                    
                }
                @Override public @Command(8) ARFuture<Long> createAccessGroup(UUID owner, UUID[] uids) {
                    var dataOut_283 = new DataInOut();
                    dataOut_283.writeByte(8);
                    String[] argsNames_285 = new String[] {
                        "owner", "uids"
                    };
                    Object[] argsValues_286 = new Object[] {
                        owner, uids
                    };
                    var result_284 = ARFuture.<Long>make();
                    localApi_260.invokeRemoteMethodAfter("createAccessGroup", result_284, argsNames_285, argsValues_286);
                    var requestId_287 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_284.done(FastMeta.META_LONG.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_284.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_283.writeInt(requestId_287);
                    FastMeta.META_UUID.serialize(localApi_260,owner,dataOut_283);
                    SerializerPackNumber.INSTANCE.put(dataOut_283,uids.length);
                    for(var forVar_288:uids) {
                        FastMeta.META_UUID.serialize(localApi_260,forVar_288,dataOut_283);
                        
                    }
                    localApi_260.sendToRemote(dataOut_283.toArray());
                    return result_284;
                    
                }
                @Override public @Command(9) ARFuture<Boolean> addToAccessGroup(long groupId, UUID uid) {
                    var dataOut_289 = new DataInOut();
                    dataOut_289.writeByte(9);
                    String[] argsNames_291 = new String[] {
                        "groupId", "uid"
                    };
                    Object[] argsValues_292 = new Object[] {
                        groupId, uid
                    };
                    var result_290 = ARFuture.<Boolean>make();
                    localApi_260.invokeRemoteMethodAfter("addToAccessGroup", result_290, argsNames_291, argsValues_292);
                    var requestId_293 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_290.done(FastMeta.META_BOOLEAN.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_290.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_289.writeInt(requestId_293);
                    dataOut_289.writeLong(groupId);
                    FastMeta.META_UUID.serialize(localApi_260,uid,dataOut_289);
                    localApi_260.sendToRemote(dataOut_289.toArray());
                    return result_290;
                    
                }
                @Override public @Command(10) ARFuture<Boolean> removeFromAccessGroup(long groupId, UUID uid) {
                    var dataOut_294 = new DataInOut();
                    dataOut_294.writeByte(10);
                    String[] argsNames_296 = new String[] {
                        "groupId", "uid"
                    };
                    Object[] argsValues_297 = new Object[] {
                        groupId, uid
                    };
                    var result_295 = ARFuture.<Boolean>make();
                    localApi_260.invokeRemoteMethodAfter("removeFromAccessGroup", result_295, argsNames_296, argsValues_297);
                    var requestId_298 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_295.done(FastMeta.META_BOOLEAN.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_295.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_294.writeInt(requestId_298);
                    dataOut_294.writeLong(groupId);
                    FastMeta.META_UUID.serialize(localApi_260,uid,dataOut_294);
                    localApi_260.sendToRemote(dataOut_294.toArray());
                    return result_295;
                    
                }
                @Override public @Command(11) AFuture checkAccessForSendMessage(UUID uid) {
                    var dataOut_299 = new DataInOut();
                    dataOut_299.writeByte(11);
                    String[] argsNames_301 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_302 = new Object[] {
                        uid
                    };
                    var result_300 = AFuture.make();
                    localApi_260.invokeRemoteMethodAfter("checkAccessForSendMessage", result_300, argsNames_301, argsValues_302);
                    var requestId_303 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_300.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_300.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_299.writeInt(requestId_303);
                    FastMeta.META_UUID.serialize(localApi_260,uid,dataOut_299);
                    localApi_260.sendToRemote(dataOut_299.toArray());
                    return result_300;
                    
                }
                @Override public @Command(12) void resolverServers(short[] sid) {
                    var dataOut_304 = new DataInOut();
                    dataOut_304.writeByte(12);
                    String[] argsNames_306 = new String[] {
                        "sid"
                    };
                    Object[] argsValues_307 = new Object[] {
                        sid
                    };
                    localApi_260.invokeRemoteMethodAfter("resolverServers", null, argsNames_306, argsValues_307);
                    SerializerPackNumber.INSTANCE.put(dataOut_304,sid.length);
                    for(var forVar_308:sid) {
                        dataOut_304.writeShort(forVar_308);
                        
                    }
                    localApi_260.sendToRemote(dataOut_304.toArray());
                    
                }
                @Override public @Command(13) void resolverClouds(UUID[] uids) {
                    var dataOut_309 = new DataInOut();
                    dataOut_309.writeByte(13);
                    String[] argsNames_311 = new String[] {
                        "uids"
                    };
                    Object[] argsValues_312 = new Object[] {
                        uids
                    };
                    localApi_260.invokeRemoteMethodAfter("resolverClouds", null, argsNames_311, argsValues_312);
                    SerializerPackNumber.INSTANCE.put(dataOut_309,uids.length);
                    for(var forVar_313:uids) {
                        FastMeta.META_UUID.serialize(localApi_260,forVar_313,dataOut_309);
                        
                    }
                    localApi_260.sendToRemote(dataOut_309.toArray());
                    
                }
                @Override public @Command(14) ARFuture<long[]> getAccessGroups(UUID uid) {
                    var dataOut_314 = new DataInOut();
                    dataOut_314.writeByte(14);
                    String[] argsNames_316 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_317 = new Object[] {
                        uid
                    };
                    var result_315 = ARFuture.<long[]>make();
                    localApi_260.invokeRemoteMethodAfter("getAccessGroups", result_315, argsNames_316, argsValues_317);
                    var requestId_318 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_315.done(FastMeta.META_ARRAY_LONG.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_315.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_314.writeInt(requestId_318);
                    FastMeta.META_UUID.serialize(localApi_260,uid,dataOut_314);
                    localApi_260.sendToRemote(dataOut_314.toArray());
                    return result_315;
                    
                }
                @Override public @Command(15) ARFuture<AccessGroup> getAccessGroup(long groupId) {
                    var dataOut_319 = new DataInOut();
                    dataOut_319.writeByte(15);
                    String[] argsNames_321 = new String[] {
                        "groupId"
                    };
                    Object[] argsValues_322 = new Object[] {
                        groupId
                    };
                    var result_320 = ARFuture.<AccessGroup>make();
                    localApi_260.invokeRemoteMethodAfter("getAccessGroup", result_320, argsNames_321, argsValues_322);
                    var requestId_323 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_320.done(AccessGroup.META.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_320.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_319.writeInt(requestId_323);
                    dataOut_319.writeLong(groupId);
                    localApi_260.sendToRemote(dataOut_319.toArray());
                    return result_320;
                    
                }
                @Override public @Command(16) ARFuture<UUID[]> getAllAccessedClients(UUID uid) {
                    var dataOut_324 = new DataInOut();
                    dataOut_324.writeByte(16);
                    String[] argsNames_326 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_327 = new Object[] {
                        uid
                    };
                    var result_325 = ARFuture.<UUID[]>make();
                    localApi_260.invokeRemoteMethodAfter("getAllAccessedClients", result_325, argsNames_326, argsValues_327);
                    var requestId_328 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_325.done(FastMeta.META_ARRAY_UUID.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_325.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_324.writeInt(requestId_328);
                    FastMeta.META_UUID.serialize(localApi_260,uid,dataOut_324);
                    localApi_260.sendToRemote(dataOut_324.toArray());
                    return result_325;
                    
                }
                @Override public @Command(17) ARFuture<Boolean> checkAccessForSendMessage2(UUID uid1, UUID uid2) {
                    var dataOut_329 = new DataInOut();
                    dataOut_329.writeByte(17);
                    String[] argsNames_331 = new String[] {
                        "uid1", "uid2"
                    };
                    Object[] argsValues_332 = new Object[] {
                        uid1, uid2
                    };
                    var result_330 = ARFuture.<Boolean>make();
                    localApi_260.invokeRemoteMethodAfter("checkAccessForSendMessage2", result_330, argsNames_331, argsValues_332);
                    var requestId_333 = localApi_260.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_330.done(FastMeta.META_BOOLEAN.deserialize(localApi_260,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_330.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_329.writeInt(requestId_333);
                    FastMeta.META_UUID.serialize(localApi_260,uid1,dataOut_329);
                    FastMeta.META_UUID.serialize(localApi_260,uid2,dataOut_329);
                    localApi_260.sendToRemote(dataOut_329.toArray());
                    return result_330;
                    
                }
                @Override public @Command(18) void sendTelemetry(Telemetry telemetry) {
                    var dataOut_334 = new DataInOut();
                    dataOut_334.writeByte(18);
                    String[] argsNames_336 = new String[] {
                        "telemetry"
                    };
                    Object[] argsValues_337 = new Object[] {
                        telemetry
                    };
                    localApi_260.invokeRemoteMethodAfter("sendTelemetry", null, argsNames_336, argsValues_337);
                    Telemetry.META.serialize(localApi_260,telemetry,dataOut_334);
                    localApi_260.sendToRemote(dataOut_334.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void backId(byte id);
    @Command(4) AFuture ping(long nextConnectMsDuration);
    @Command(5) void client(UUID uid, ClientApiStream stream);
    @Command(6) void sendMessage(Message msg);
    @Command(7) void sendMessages(Message[] msg);
    @Command(8) ARFuture<Long> createAccessGroup(UUID owner, UUID[] uids);
    @Command(9) ARFuture<Boolean> addToAccessGroup(long groupId, UUID uid);
    @Command(10) ARFuture<Boolean> removeFromAccessGroup(long groupId, UUID uid);
    @Command(11) AFuture checkAccessForSendMessage(UUID uid);
    @Command(12) void resolverServers(short[] sid);
    @Command(13) void resolverClouds(UUID[] uids);
    @Command(14) ARFuture<long[]> getAccessGroups(UUID uid);
    @Command(15) ARFuture<AccessGroup> getAccessGroup(long groupId);
    @Command(16) ARFuture<UUID[]> getAllAccessedClients(UUID uid);
    @Command(17) ARFuture<Boolean> checkAccessForSendMessage2(UUID uid1, UUID uid2);
    @Command(18) void sendTelemetry(Telemetry telemetry);
    
}