package io.aether.api.clientserverapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ClientApiSafe  {
    FastMetaApi<ClientApiSafe,ClientApiSafeRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_62, DataIn in_, ClientApiSafe localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_63 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_62,in_);
                        var futureRec_64 = serializeContextVar_62.getFuture(requestId_63);
                        if(futureRec_64 != null) futureRec_64.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_65 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_62,in_);
                        var futureRec_66 = serializeContextVar_62.getFuture(requestId_65);
                        if(futureRec_66 != null) futureRec_66.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        UUID uid_68;
                        uid_68=FastMeta.META_UUID.deserialize(serializeContextVar_62,in_);
                        String[] argsNames_69 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_70 = new Object[] {
                            uid_68
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("changeParent", argsNames_69, argsValues_70);
                        localApi.changeParent(uid_68);
                        serializeContextVar_62.invokeLocalMethodAfter("changeParent", null, argsNames_69, argsValues_70);
                        break;
                        
                    }
                    case 4:  {
                        UUID alias_72;
                        alias_72=FastMeta.META_UUID.deserialize(serializeContextVar_62,in_);
                        String[] argsNames_73 = new String[] {
                            "alias"
                        };
                        Object[] argsValues_74 = new Object[] {
                            alias_72
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("changeAlias", argsNames_73, argsValues_74);
                        localApi.changeAlias(alias_72);
                        serializeContextVar_62.invokeLocalMethodAfter("changeAlias", null, argsNames_73, argsValues_74);
                        break;
                        
                    }
                    case 5:  {
                        UUID uid_76;
                        uid_76=FastMeta.META_UUID.deserialize(serializeContextVar_62,in_);
                        String[] argsNames_77 = new String[] {
                            "uid"
                        };
                        Object[] argsValues_78 = new Object[] {
                            uid_76
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("newChild", argsNames_77, argsValues_78);
                        localApi.newChild(uid_76);
                        serializeContextVar_62.invokeLocalMethodAfter("newChild", null, argsNames_77, argsValues_78);
                        break;
                        
                    }
                    case 6:  {
                        Message[] msg_80;
                        var arraySize_81 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        msg_80=new Message[arraySize_81];
                        for(var forVar_82=0; forVar_82<arraySize_81; forVar_82++) {
                            msg_80[forVar_82]=Message.META.deserialize(serializeContextVar_62,in_);
                            
                        }
                        String[] argsNames_83 = new String[] {
                            "msg"
                        };
                        Object[] argsValues_84 = new Object[] {
                            msg_80
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("sendMessages", argsNames_83, argsValues_84);
                        localApi.sendMessages(msg_80);
                        serializeContextVar_62.invokeLocalMethodAfter("sendMessages", null, argsNames_83, argsValues_84);
                        break;
                        
                    }
                    case 7:  {
                        ServerDescriptor serverDescriptor_86;
                        serverDescriptor_86=ServerDescriptor.META.deserialize(serializeContextVar_62,in_);
                        String[] argsNames_87 = new String[] {
                            "serverDescriptor"
                        };
                        Object[] argsValues_88 = new Object[] {
                            serverDescriptor_86
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("sendServerDescriptor", argsNames_87, argsValues_88);
                        localApi.sendServerDescriptor(serverDescriptor_86);
                        serializeContextVar_62.invokeLocalMethodAfter("sendServerDescriptor", null, argsNames_87, argsValues_88);
                        break;
                        
                    }
                    case 8:  {
                        ServerDescriptor[] serverDescriptors_90;
                        var arraySize_91 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        serverDescriptors_90=new ServerDescriptor[arraySize_91];
                        for(var forVar_92=0; forVar_92<arraySize_91; forVar_92++) {
                            serverDescriptors_90[forVar_92]=ServerDescriptor.META.deserialize(serializeContextVar_62,in_);
                            
                        }
                        String[] argsNames_93 = new String[] {
                            "serverDescriptors"
                        };
                        Object[] argsValues_94 = new Object[] {
                            serverDescriptors_90
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("sendServerDescriptors", argsNames_93, argsValues_94);
                        localApi.sendServerDescriptors(serverDescriptors_90);
                        serializeContextVar_62.invokeLocalMethodAfter("sendServerDescriptors", null, argsNames_93, argsValues_94);
                        break;
                        
                    }
                    case 9:  {
                        UUID uid_96;
                        Cloud cloud_97;
                        uid_96=FastMeta.META_UUID.deserialize(serializeContextVar_62,in_);
                        cloud_97=Cloud.META.deserialize(serializeContextVar_62,in_);
                        String[] argsNames_98 = new String[] {
                            "uid", "cloud"
                        };
                        Object[] argsValues_99 = new Object[] {
                            uid_96, cloud_97
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("sendCloud", argsNames_98, argsValues_99);
                        localApi.sendCloud(uid_96,cloud_97);
                        serializeContextVar_62.invokeLocalMethodAfter("sendCloud", null, argsNames_98, argsValues_99);
                        break;
                        
                    }
                    case 10:  {
                        UUIDAndCloud[] clouds_101;
                        var arraySize_102 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        clouds_101=new UUIDAndCloud[arraySize_102];
                        for(var forVar_103=0; forVar_103<arraySize_102; forVar_103++) {
                            clouds_101[forVar_103]=UUIDAndCloud.META.deserialize(serializeContextVar_62,in_);
                            
                        }
                        String[] argsNames_104 = new String[] {
                            "clouds"
                        };
                        Object[] argsValues_105 = new Object[] {
                            clouds_101
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("sendClouds", argsNames_104, argsValues_105);
                        localApi.sendClouds(clouds_101);
                        serializeContextVar_62.invokeLocalMethodAfter("sendClouds", null, argsNames_104, argsValues_105);
                        break;
                        
                    }
                    case 11:  {
                        String[] argsNames_107 = new String[] {
                            
                        };
                        Object[] argsValues_108 = new Object[] {
                            
                        };
                        serializeContextVar_62.invokeLocalMethodBefore("requestTelemetry", argsNames_107, argsValues_108);
                        localApi.requestTelemetry();
                        serializeContextVar_62.invokeLocalMethodAfter("requestTelemetry", null, argsNames_107, argsValues_108);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ClientApiSafeRemote makeRemote(FastFutureContext localApi_110) {
            return new ClientApiSafeRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_110.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_110;
                    
                }
                @Override public @Command(3) void changeParent(UUID uid) {
                    var dataOut_111 = new DataInOut();
                    dataOut_111.writeByte(3);
                    String[] argsNames_113 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_114 = new Object[] {
                        uid
                    };
                    localApi_110.invokeRemoteMethodAfter("changeParent", null, argsNames_113, argsValues_114);
                    FastMeta.META_UUID.serialize(localApi_110,uid,dataOut_111);
                    localApi_110.sendToRemote(dataOut_111.toArray());
                    
                }
                @Override public @Command(4) void changeAlias(UUID alias) {
                    var dataOut_115 = new DataInOut();
                    dataOut_115.writeByte(4);
                    String[] argsNames_117 = new String[] {
                        "alias"
                    };
                    Object[] argsValues_118 = new Object[] {
                        alias
                    };
                    localApi_110.invokeRemoteMethodAfter("changeAlias", null, argsNames_117, argsValues_118);
                    FastMeta.META_UUID.serialize(localApi_110,alias,dataOut_115);
                    localApi_110.sendToRemote(dataOut_115.toArray());
                    
                }
                @Override public @Command(5) void newChild(UUID uid) {
                    var dataOut_119 = new DataInOut();
                    dataOut_119.writeByte(5);
                    String[] argsNames_121 = new String[] {
                        "uid"
                    };
                    Object[] argsValues_122 = new Object[] {
                        uid
                    };
                    localApi_110.invokeRemoteMethodAfter("newChild", null, argsNames_121, argsValues_122);
                    FastMeta.META_UUID.serialize(localApi_110,uid,dataOut_119);
                    localApi_110.sendToRemote(dataOut_119.toArray());
                    
                }
                @Override public @Command(6) void sendMessages(Message[] msg) {
                    var dataOut_123 = new DataInOut();
                    dataOut_123.writeByte(6);
                    String[] argsNames_125 = new String[] {
                        "msg"
                    };
                    Object[] argsValues_126 = new Object[] {
                        msg
                    };
                    localApi_110.invokeRemoteMethodAfter("sendMessages", null, argsNames_125, argsValues_126);
                    SerializerPackNumber.INSTANCE.put(dataOut_123,msg.length);
                    for(var forVar_127:msg) {
                        Message.META.serialize(localApi_110,forVar_127,dataOut_123);
                        
                    }
                    localApi_110.sendToRemote(dataOut_123.toArray());
                    
                }
                @Override public @Command(7) void sendServerDescriptor(ServerDescriptor serverDescriptor) {
                    var dataOut_128 = new DataInOut();
                    dataOut_128.writeByte(7);
                    String[] argsNames_130 = new String[] {
                        "serverDescriptor"
                    };
                    Object[] argsValues_131 = new Object[] {
                        serverDescriptor
                    };
                    localApi_110.invokeRemoteMethodAfter("sendServerDescriptor", null, argsNames_130, argsValues_131);
                    ServerDescriptor.META.serialize(localApi_110,serverDescriptor,dataOut_128);
                    localApi_110.sendToRemote(dataOut_128.toArray());
                    
                }
                @Override public @Command(8) void sendServerDescriptors(ServerDescriptor[] serverDescriptors) {
                    var dataOut_132 = new DataInOut();
                    dataOut_132.writeByte(8);
                    String[] argsNames_134 = new String[] {
                        "serverDescriptors"
                    };
                    Object[] argsValues_135 = new Object[] {
                        serverDescriptors
                    };
                    localApi_110.invokeRemoteMethodAfter("sendServerDescriptors", null, argsNames_134, argsValues_135);
                    SerializerPackNumber.INSTANCE.put(dataOut_132,serverDescriptors.length);
                    for(var forVar_136:serverDescriptors) {
                        ServerDescriptor.META.serialize(localApi_110,forVar_136,dataOut_132);
                        
                    }
                    localApi_110.sendToRemote(dataOut_132.toArray());
                    
                }
                @Override public @Command(9) void sendCloud(UUID uid, Cloud cloud) {
                    var dataOut_137 = new DataInOut();
                    dataOut_137.writeByte(9);
                    String[] argsNames_139 = new String[] {
                        "uid", "cloud"
                    };
                    Object[] argsValues_140 = new Object[] {
                        uid, cloud
                    };
                    localApi_110.invokeRemoteMethodAfter("sendCloud", null, argsNames_139, argsValues_140);
                    FastMeta.META_UUID.serialize(localApi_110,uid,dataOut_137);
                    Cloud.META.serialize(localApi_110,cloud,dataOut_137);
                    localApi_110.sendToRemote(dataOut_137.toArray());
                    
                }
                @Override public @Command(10) void sendClouds(UUIDAndCloud[] clouds) {
                    var dataOut_141 = new DataInOut();
                    dataOut_141.writeByte(10);
                    String[] argsNames_143 = new String[] {
                        "clouds"
                    };
                    Object[] argsValues_144 = new Object[] {
                        clouds
                    };
                    localApi_110.invokeRemoteMethodAfter("sendClouds", null, argsNames_143, argsValues_144);
                    SerializerPackNumber.INSTANCE.put(dataOut_141,clouds.length);
                    for(var forVar_145:clouds) {
                        UUIDAndCloud.META.serialize(localApi_110,forVar_145,dataOut_141);
                        
                    }
                    localApi_110.sendToRemote(dataOut_141.toArray());
                    
                }
                @Override public @Command(11) void requestTelemetry() {
                    var dataOut_146 = new DataInOut();
                    dataOut_146.writeByte(11);
                    String[] argsNames_148 = new String[] {
                        
                    };
                    Object[] argsValues_149 = new Object[] {
                        
                    };
                    localApi_110.invokeRemoteMethodAfter("requestTelemetry", null, argsNames_148, argsValues_149);
                    localApi_110.sendToRemote(dataOut_146.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void changeParent(UUID uid);
    @Command(4) void changeAlias(UUID alias);
    @Command(5) void newChild(UUID uid);
    @Command(6) void sendMessages(Message[] msg);
    @Command(7) void sendServerDescriptor(ServerDescriptor serverDescriptor);
    @Command(8) void sendServerDescriptors(ServerDescriptor[] serverDescriptors);
    @Command(9) void sendCloud(UUID uid, Cloud cloud);
    @Command(10) void sendClouds(UUIDAndCloud[] clouds);
    @Command(11) void requestTelemetry();
    
}