package io.aether.api.clientserverapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class TelemetryCPP extends Telemetry implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 1;
        
    }
    public static final FastMetaType<TelemetryCPP> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_4, TelemetryCPP obj_5, DataOut out_6) {
            out_6.writeInt(obj_5.utm_id);
            SerializerPackNumber.INSTANCE.put(out_6,obj_5.blob.length);
            out_6.write(obj_5.blob);
            var stringData_8=obj_5.lib_version.getBytes();
            SerializerPackNumber.INSTANCE.put(out_6,stringData_8.length);
            out_6.write(stringData_8);
            var stringData_9=obj_5.os.getBytes();
            SerializerPackNumber.INSTANCE.put(out_6,stringData_9.length);
            out_6.write(stringData_9);
            var stringData_10=obj_5.compiler.getBytes();
            SerializerPackNumber.INSTANCE.put(out_6,stringData_10.length);
            out_6.write(stringData_10);
            
        }
        @Override public TelemetryCPP deserialize(FastFutureContext serializeContextVar_4, DataIn in_7) {
            int utm_id_11;
            byte[] blob_12;
            String lib_version_13;
            String os_14;
            String compiler_15;
            utm_id_11=in_7.readInt();
            var arraySize_16 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            blob_12=new byte[arraySize_16];
            in_7.read(blob_12);
            byte[] stringData_17;
            var arraySize_18 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            stringData_17=new byte[arraySize_18];
            in_7.read(stringData_17);
            lib_version_13=new String(stringData_17);
            byte[] stringData_19;
            var arraySize_20 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            stringData_19=new byte[arraySize_20];
            in_7.read(stringData_19);
            os_14=new String(stringData_19);
            byte[] stringData_21;
            var arraySize_22 = DeserializerPackNumber.INSTANCE.put(in_7).intValue();
            stringData_21=new byte[arraySize_22];
            in_7.read(stringData_21);
            compiler_15=new String(stringData_21);
            return new TelemetryCPP(utm_id_11,blob_12,lib_version_13,os_14,compiler_15);
            
        }
        
    };
    public static final FastMetaType<TelemetryCPP> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_23, TelemetryCPP obj_24, DataOut out_25) {
            TelemetryCPP.META_BODY.serialize(serializeContextVar_23, obj_24, out_25);
            
        }
        @Override public TelemetryCPP deserialize(FastFutureContext serializeContextVar_23, DataIn in_26) {
            return TelemetryCPP.META_BODY.deserialize(serializeContextVar_23, in_26);
            
        }
        
    };
    protected final int utm_id;
    protected final byte[] blob;
    protected final String lib_version;
    protected final String os;
    protected final String compiler;
    public TelemetryCPP(int utm_id, byte[] blob, String lib_version, String os, String compiler)  {
        if (blob == null)  {
            throw new java.lang.NullPointerException("Field 'blob' cannot be null.");
            
        }
        this.utm_id = utm_id;
        this.blob = blob;
        this.lib_version = lib_version;
        this.os = os;
        this.compiler = compiler;
        
    }
    public int getUtm_id()  {
        return this.utm_id;
        
    }
    public byte[] getBlob()  {
        return this.blob;
        
    }
    public boolean blobContains(byte el)  {
        return ByteSet.of(this.blob).contains(el);
        
    }
    public String getLib_version()  {
        return this.lib_version;
        
    }
    public String getOs()  {
        return this.os;
        
    }
    public String getCompiler()  {
        return this.compiler;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof TelemetryCPP)) return false;
        TelemetryCPP that = (TelemetryCPP) o;
        return java.util.Objects.equals(this.utm_id, that.utm_id) && java.util.Arrays.equals(this.blob, that.blob) && java.util.Objects.equals(this.lib_version, that.lib_version) && java.util.Objects.equals(this.os, that.os) && java.util.Objects.equals(this.compiler, that.compiler);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.utm_id, java.util.Arrays.hashCode(this.blob), this.lib_version, this.os, this.compiler);
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("TelemetryCPP(");
        sb.add("utm_id:");
        sb.add(this.utm_id);
        sb.add(", ");
        sb.add("blob:");
        sb.add(this.blob);
        sb.add(", ");
        sb.add("lib_version:");
        sb.add(this.lib_version);
        sb.add(", ");
        sb.add("os:");
        sb.add(this.os);
        sb.add(", ");
        sb.add("compiler:");
        sb.add(this.compiler);
        sb.add(')');
        
    }
    
}