package io.aether.api.clientserverapi;
import io.aether.api.common.*;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class Message implements io.aether.utils.ToString  {
    public static final FastMetaType<Message> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_27, Message obj_28, DataOut out_29) {
            FastMeta.META_UUID.serialize(serializeContextVar_27,obj_28.uid,out_29);
            SerializerPackNumber.INSTANCE.put(out_29,obj_28.data.length);
            out_29.write(obj_28.data);
            
        }
        @Override public Message deserialize(FastFutureContext serializeContextVar_27, DataIn in_30) {
            UUID uid_31;
            byte[] data_32;
            uid_31=FastMeta.META_UUID.deserialize(serializeContextVar_27,in_30);
            var arraySize_33 = DeserializerPackNumber.INSTANCE.put(in_30).intValue();
            data_32=new byte[arraySize_33];
            in_30.read(data_32);
            return new Message(uid_31,data_32);
            
        }
        
    };
    public static final FastMetaType<Message> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_34, Message obj_35, DataOut out_36) {
            Message.META_BODY.serialize(serializeContextVar_34, obj_35, out_36);
            
        }
        @Override public Message deserialize(FastFutureContext serializeContextVar_34, DataIn in_37) {
            return Message.META_BODY.deserialize(serializeContextVar_34, in_37);
            
        }
        
    };
    protected final UUID uid;
    protected final byte[] data;
    public Message(UUID uid, byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        this.uid = uid;
        this.data = data;
        
    }
    public UUID getUid()  {
        return this.uid;
        
    }
    public byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof Message)) return false;
        Message that = (Message) o;
        return java.util.Objects.equals(this.uid, that.uid) && java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.uid, java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("Message(");
        sb.add("uid:");
        sb.add(this.uid);
        sb.add(", ");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}