package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class AccessCheckPair implements io.aether.utils.ToString  {
    public static final FastMetaType<AccessCheckPair> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_354, AccessCheckPair obj_355, DataOut out_356) {
            FastMeta.META_UUID.serialize(serializeContextVar_354,obj_355.sourceUid,out_356);
            FastMeta.META_UUID.serialize(serializeContextVar_354,obj_355.targetUid,out_356);
            
        }
        @Override public AccessCheckPair deserialize(FastFutureContext serializeContextVar_354, DataIn in_357) {
            UUID sourceUid_358;
            UUID targetUid_359;
            sourceUid_358=FastMeta.META_UUID.deserialize(serializeContextVar_354,in_357);
            targetUid_359=FastMeta.META_UUID.deserialize(serializeContextVar_354,in_357);
            return new AccessCheckPair(sourceUid_358,targetUid_359);
            
        }
        
    };
    public static final FastMetaType<AccessCheckPair> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_360, AccessCheckPair obj_361, DataOut out_362) {
            AccessCheckPair.META_BODY.serialize(serializeContextVar_360, obj_361, out_362);
            
        }
        @Override public AccessCheckPair deserialize(FastFutureContext serializeContextVar_360, DataIn in_363) {
            return AccessCheckPair.META_BODY.deserialize(serializeContextVar_360, in_363);
            
        }
        
    };
    protected final UUID sourceUid;
    protected final UUID targetUid;
    public AccessCheckPair(UUID sourceUid, UUID targetUid)  {
        this.sourceUid = sourceUid;
        this.targetUid = targetUid;
        
    }
    public UUID getSourceUid()  {
        return this.sourceUid;
        
    }
    public UUID getTargetUid()  {
        return this.targetUid;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof AccessCheckPair)) return false;
        AccessCheckPair that = (AccessCheckPair) o;
        return java.util.Objects.equals(this.sourceUid, that.sourceUid) && java.util.Objects.equals(this.targetUid, that.targetUid);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.sourceUid, this.targetUid);
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("AccessCheckPair(");
        sb.add("sourceUid:");
        sb.add(this.sourceUid);
        sb.add(", ");
        sb.add("targetUid:");
        sb.add(this.targetUid);
        sb.add(')');
        
    }
    
}