package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class AccessCheckResult implements io.aether.utils.ToString  {
    public static final FastMetaType<AccessCheckResult> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_364, AccessCheckResult obj_365, DataOut out_366) {
            FastMeta.META_UUID.serialize(serializeContextVar_364,obj_365.sourceUid,out_366);
            FastMeta.META_UUID.serialize(serializeContextVar_364,obj_365.targetUid,out_366);
            out_366.writeByte(obj_365.hasAccess?1:0);
            
        }
        @Override public AccessCheckResult deserialize(FastFutureContext serializeContextVar_364, DataIn in_367) {
            UUID sourceUid_368;
            UUID targetUid_369;
            boolean hasAccess_370;
            sourceUid_368=FastMeta.META_UUID.deserialize(serializeContextVar_364,in_367);
            targetUid_369=FastMeta.META_UUID.deserialize(serializeContextVar_364,in_367);
            hasAccess_370=in_367.readByte()>0;
            return new AccessCheckResult(sourceUid_368,targetUid_369,hasAccess_370);
            
        }
        
    };
    public static final FastMetaType<AccessCheckResult> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_371, AccessCheckResult obj_372, DataOut out_373) {
            AccessCheckResult.META_BODY.serialize(serializeContextVar_371, obj_372, out_373);
            
        }
        @Override public AccessCheckResult deserialize(FastFutureContext serializeContextVar_371, DataIn in_374) {
            return AccessCheckResult.META_BODY.deserialize(serializeContextVar_371, in_374);
            
        }
        
    };
    protected final UUID sourceUid;
    protected final UUID targetUid;
    protected final boolean hasAccess;
    public AccessCheckResult(UUID sourceUid, UUID targetUid, boolean hasAccess)  {
        this.sourceUid = sourceUid;
        this.targetUid = targetUid;
        this.hasAccess = hasAccess;
        
    }
    public UUID getSourceUid()  {
        return this.sourceUid;
        
    }
    public UUID getTargetUid()  {
        return this.targetUid;
        
    }
    public boolean isHasAccess()  {
        return this.hasAccess;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof AccessCheckResult)) return false;
        AccessCheckResult that = (AccessCheckResult) o;
        return java.util.Objects.equals(this.sourceUid, that.sourceUid) && java.util.Objects.equals(this.targetUid, that.targetUid) && java.util.Objects.equals(this.hasAccess, that.hasAccess);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.sourceUid, this.targetUid, this.hasAccess);
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("AccessCheckResult(");
        sb.add("sourceUid:");
        sb.add(this.sourceUid);
        sb.add(", ");
        sb.add("targetUid:");
        sb.add(this.targetUid);
        sb.add(", ");
        sb.add("hasAccess:");
        sb.add(this.hasAccess);
        sb.add(')');
        
    }
    
}