package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HydrogenCurvePrivate extends KeyAsymmetricPrivate implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 1;
        
    }
    public static final FastMetaType<HydrogenCurvePrivate> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_42, HydrogenCurvePrivate obj_43, DataOut out_44) {
            if(obj_43.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_43.data=="+obj_43.data.length+" but must be 32");
            out_44.write(obj_43.data);
            
        }
        @Override public HydrogenCurvePrivate deserialize(FastFutureContext serializeContextVar_42, DataIn in_45) {
            byte[] data_46;
            var arraySize_47=32;
            data_46=new byte[arraySize_47];
            in_45.read(data_46);
            return new HydrogenCurvePrivate(data_46);
            
        }
        
    };
    public static final FastMetaType<HydrogenCurvePrivate> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_48, HydrogenCurvePrivate obj_49, DataOut out_50) {
            HydrogenCurvePrivate.META_BODY.serialize(serializeContextVar_48, obj_49, out_50);
            
        }
        @Override public HydrogenCurvePrivate deserialize(FastFutureContext serializeContextVar_48, DataIn in_51) {
            return HydrogenCurvePrivate.META_BODY.deserialize(serializeContextVar_48, in_51);
            
        }
        
    };
    protected final byte[] data;
    public HydrogenCurvePrivate(byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof HydrogenCurvePrivate)) return false;
        HydrogenCurvePrivate that = (HydrogenCurvePrivate) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("HydrogenCurvePrivate(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}