package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HydrogenCurvePublic extends KeyAsymmetricPublic implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 2;
        
    }
    public static final FastMetaType<HydrogenCurvePublic> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_52, HydrogenCurvePublic obj_53, DataOut out_54) {
            if(obj_53.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_53.data=="+obj_53.data.length+" but must be 32");
            out_54.write(obj_53.data);
            
        }
        @Override public HydrogenCurvePublic deserialize(FastFutureContext serializeContextVar_52, DataIn in_55) {
            byte[] data_56;
            var arraySize_57=32;
            data_56=new byte[arraySize_57];
            in_55.read(data_56);
            return new HydrogenCurvePublic(data_56);
            
        }
        
    };
    public static final FastMetaType<HydrogenCurvePublic> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_58, HydrogenCurvePublic obj_59, DataOut out_60) {
            HydrogenCurvePublic.META_BODY.serialize(serializeContextVar_58, obj_59, out_60);
            
        }
        @Override public HydrogenCurvePublic deserialize(FastFutureContext serializeContextVar_58, DataIn in_61) {
            return HydrogenCurvePublic.META_BODY.deserialize(serializeContextVar_58, in_61);
            
        }
        
    };
    protected final byte[] data;
    public HydrogenCurvePublic(byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof HydrogenCurvePublic)) return false;
        HydrogenCurvePublic that = (HydrogenCurvePublic) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("HydrogenCurvePublic(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}