package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HydrogenSecretBox extends KeySymmetric implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 3;
        
    }
    public static final FastMetaType<HydrogenSecretBox> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_62, HydrogenSecretBox obj_63, DataOut out_64) {
            if(obj_63.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_63.data=="+obj_63.data.length+" but must be 32");
            out_64.write(obj_63.data);
            
        }
        @Override public HydrogenSecretBox deserialize(FastFutureContext serializeContextVar_62, DataIn in_65) {
            byte[] data_66;
            var arraySize_67=32;
            data_66=new byte[arraySize_67];
            in_65.read(data_66);
            return new HydrogenSecretBox(data_66);
            
        }
        
    };
    public static final FastMetaType<HydrogenSecretBox> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_68, HydrogenSecretBox obj_69, DataOut out_70) {
            HydrogenSecretBox.META_BODY.serialize(serializeContextVar_68, obj_69, out_70);
            
        }
        @Override public HydrogenSecretBox deserialize(FastFutureContext serializeContextVar_68, DataIn in_71) {
            return HydrogenSecretBox.META_BODY.deserialize(serializeContextVar_68, in_71);
            
        }
        
    };
    protected final byte[] data;
    public HydrogenSecretBox(byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof HydrogenSecretBox)) return false;
        HydrogenSecretBox that = (HydrogenSecretBox) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("HydrogenSecretBox(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}