package io.aether.api.common;

import io.aether.utils.flow.Flow;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public interface IPAddressUtil {
    static IPAddress[] of(URI uri){
        try {
            return Flow.flow(InetAddress.getAllByName(uri.getHost())).map(a->{
                var aa=a.getAddress();
                if(aa.length==4){
                    return new IPAddressV4(aa);
                }else if(aa.length==6){
                    return new IPAddressV6(aa);
                }else{
                    throw new UnknownHostException();
                }
            }).toArray(IPAddress.class);
        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}
