package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class Key implements io.aether.utils.ToString  {
    public abstract byte[] getData();
    public abstract int getAetherTypeId();
    public static final FastMetaType<Key> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_0, Key obj_1, DataOut out_2) {
            out_2.writeByte(obj_1.getAetherTypeId());
            switch(obj_1.getAetherTypeId()) {
                case 6: SodiumChacha20Poly1305.META_BODY.serialize(serializeContextVar_0, (SodiumChacha20Poly1305)obj_1, out_2);
                break;
                case 3: HydrogenSecretBox.META_BODY.serialize(serializeContextVar_0, (HydrogenSecretBox)obj_1, out_2);
                break;
                case 2: HydrogenCurvePublic.META_BODY.serialize(serializeContextVar_0, (HydrogenCurvePublic)obj_1, out_2);
                break;
                case 8: SodiumCurvePublic.META_BODY.serialize(serializeContextVar_0, (SodiumCurvePublic)obj_1, out_2);
                break;
                case 1: HydrogenCurvePrivate.META_BODY.serialize(serializeContextVar_0, (HydrogenCurvePrivate)obj_1, out_2);
                break;
                case 7: SodiumCurvePrivate.META_BODY.serialize(serializeContextVar_0, (SodiumCurvePrivate)obj_1, out_2);
                break;
                case 10: SodiumSignPublic.META_BODY.serialize(serializeContextVar_0, (SodiumSignPublic)obj_1, out_2);
                break;
                case 5: HydrogenSignPublic.META_BODY.serialize(serializeContextVar_0, (HydrogenSignPublic)obj_1, out_2);
                break;
                case 9: SodiumSignPrivate.META_BODY.serialize(serializeContextVar_0, (SodiumSignPrivate)obj_1, out_2);
                break;
                case 4: HydrogenSignPrivate.META_BODY.serialize(serializeContextVar_0, (HydrogenSignPrivate)obj_1, out_2);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'Key' with unknown type id " + obj_1.getAetherTypeId());
                
            }
            
        }
        @Override public Key deserialize(FastFutureContext serializeContextVar_0, DataIn in_3) {
            var typeId = in_3.readUByte();
            switch(typeId) {
                case 6: return (Key)SodiumChacha20Poly1305.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 3: return (Key)HydrogenSecretBox.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 2: return (Key)HydrogenCurvePublic.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 8: return (Key)SodiumCurvePublic.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 1: return (Key)HydrogenCurvePrivate.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 7: return (Key)SodiumCurvePrivate.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 10: return (Key)SodiumSignPublic.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 5: return (Key)HydrogenSignPublic.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 9: return (Key)SodiumSignPrivate.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 4: return (Key)HydrogenSignPrivate.META_BODY.deserialize(serializeContextVar_0,in_3);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'Key'");
                
            }
            
        }
        
    };
    public Key()  {
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof Key)) return false;
        Key that = (Key) o;
        return true;
        
    }
    @Override public int hashCode()  {
        return 0;
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("Key(");
        sb.add(')');
        
    }
    
}