package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class Sign implements io.aether.utils.ToString  {
    public abstract byte[] getData();
    public abstract int getAetherTypeId();
    public static final FastMetaType<Sign> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_132, Sign obj_133, DataOut out_134) {
            out_134.writeByte(obj_133.getAetherTypeId());
            switch(obj_133.getAetherTypeId()) {
                case 1: SignAE_ED25519.META_BODY.serialize(serializeContextVar_132, (SignAE_ED25519)obj_133, out_134);
                break;
                case 2: SignHYDROGEN.META_BODY.serialize(serializeContextVar_132, (SignHYDROGEN)obj_133, out_134);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'Sign' with unknown type id " + obj_133.getAetherTypeId());
                
            }
            
        }
        @Override public Sign deserialize(FastFutureContext serializeContextVar_132, DataIn in_135) {
            var typeId = in_135.readUByte();
            switch(typeId) {
                case 1: return (Sign)SignAE_ED25519.META_BODY.deserialize(serializeContextVar_132,in_135);
                case 2: return (Sign)SignHYDROGEN.META_BODY.deserialize(serializeContextVar_132,in_135);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'Sign'");
                
            }
            
        }
        
    };
    public Sign()  {
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof Sign)) return false;
        Sign that = (Sign) o;
        return true;
        
    }
    @Override public int hashCode()  {
        return 0;
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("Sign(");
        sb.add(')');
        
    }
    
}