package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class SodiumCurvePublic extends KeyAsymmetricPublic implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 8;
        
    }
    public static final FastMetaType<SodiumCurvePublic> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_72, SodiumCurvePublic obj_73, DataOut out_74) {
            if(obj_73.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_73.data=="+obj_73.data.length+" but must be 32");
            out_74.write(obj_73.data);
            
        }
        @Override public SodiumCurvePublic deserialize(FastFutureContext serializeContextVar_72, DataIn in_75) {
            byte[] data_76;
            var arraySize_77=32;
            data_76=new byte[arraySize_77];
            in_75.read(data_76);
            return new SodiumCurvePublic(data_76);
            
        }
        
    };
    public static final FastMetaType<SodiumCurvePublic> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_78, SodiumCurvePublic obj_79, DataOut out_80) {
            SodiumCurvePublic.META_BODY.serialize(serializeContextVar_78, obj_79, out_80);
            
        }
        @Override public SodiumCurvePublic deserialize(FastFutureContext serializeContextVar_78, DataIn in_81) {
            return SodiumCurvePublic.META_BODY.deserialize(serializeContextVar_78, in_81);
            
        }
        
    };
    protected final byte[] data;
    public SodiumCurvePublic(byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof SodiumCurvePublic)) return false;
        SodiumCurvePublic that = (SodiumCurvePublic) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("SodiumCurvePublic(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}