package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class SodiumSignPublic extends KeySignPublic implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 10;
        
    }
    public static final FastMetaType<SodiumSignPublic> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_102, SodiumSignPublic obj_103, DataOut out_104) {
            if(obj_103.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_103.data=="+obj_103.data.length+" but must be 32");
            out_104.write(obj_103.data);
            
        }
        @Override public SodiumSignPublic deserialize(FastFutureContext serializeContextVar_102, DataIn in_105) {
            byte[] data_106;
            var arraySize_107=32;
            data_106=new byte[arraySize_107];
            in_105.read(data_106);
            return new SodiumSignPublic(data_106);
            
        }
        
    };
    public static final FastMetaType<SodiumSignPublic> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_108, SodiumSignPublic obj_109, DataOut out_110) {
            SodiumSignPublic.META_BODY.serialize(serializeContextVar_108, obj_109, out_110);
            
        }
        @Override public SodiumSignPublic deserialize(FastFutureContext serializeContextVar_108, DataIn in_111) {
            return SodiumSignPublic.META_BODY.deserialize(serializeContextVar_108, in_111);
            
        }
        
    };
    protected final byte[] data;
    public SodiumSignPublic(byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof SodiumSignPublic)) return false;
        SodiumSignPublic that = (SodiumSignPublic) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("SodiumSignPublic(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}