package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class UUIDAndCloud implements io.aether.utils.ToString  {
    public static final FastMetaType<UUIDAndCloud> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_310, UUIDAndCloud obj_311, DataOut out_312) {
            FastMeta.META_UUID.serialize(serializeContextVar_310,obj_311.uid,out_312);
            Cloud.META.serialize(serializeContextVar_310,obj_311.cloud,out_312);
            
        }
        @Override public UUIDAndCloud deserialize(FastFutureContext serializeContextVar_310, DataIn in_313) {
            UUID uid_314;
            Cloud cloud_315;
            uid_314=FastMeta.META_UUID.deserialize(serializeContextVar_310,in_313);
            cloud_315=Cloud.META.deserialize(serializeContextVar_310,in_313);
            return new UUIDAndCloud(uid_314,cloud_315);
            
        }
        
    };
    public static final FastMetaType<UUIDAndCloud> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_316, UUIDAndCloud obj_317, DataOut out_318) {
            UUIDAndCloud.META_BODY.serialize(serializeContextVar_316, obj_317, out_318);
            
        }
        @Override public UUIDAndCloud deserialize(FastFutureContext serializeContextVar_316, DataIn in_319) {
            return UUIDAndCloud.META_BODY.deserialize(serializeContextVar_316, in_319);
            
        }
        
    };
    protected final UUID uid;
    protected final Cloud cloud;
    public UUIDAndCloud(UUID uid, Cloud cloud)  {
        if (cloud == null)  {
            throw new java.lang.NullPointerException("Field 'cloud' cannot be null.");
            
        }
        this.uid = uid;
        this.cloud = cloud;
        
    }
    public UUID getUid()  {
        return this.uid;
        
    }
    public Cloud getCloud()  {
        return this.cloud;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof UUIDAndCloud)) return false;
        UUIDAndCloud that = (UUIDAndCloud) o;
        return java.util.Objects.equals(this.uid, that.uid) && java.util.Objects.equals(this.cloud, that.cloud);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.uid, this.cloud);
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("UUIDAndCloud(");
        sb.add("uid:");
        sb.add(this.uid);
        sb.add(", ");
        sb.add("cloud:");
        sb.add(this.cloud);
        sb.add(')');
        
    }
    
}