package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class WorkProofDTO implements io.aether.utils.ToString  {
    public static final FastMetaType<WorkProofDTO> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_181, WorkProofDTO obj_182, DataOut out_183) {
            var stringData_185=obj_182.salt.getBytes();
            SerializerPackNumber.INSTANCE.put(out_183,stringData_185.length);
            out_183.write(stringData_185);
            var stringData_186=obj_182.suffix.getBytes();
            SerializerPackNumber.INSTANCE.put(out_183,stringData_186.length);
            out_183.write(stringData_186);
            out_183.writeByte(obj_182.poolSize);
            out_183.writeInt(obj_182.maxHashVal);
            SignedKey.META.serialize(serializeContextVar_181,obj_182.globalKey,out_183);
            
        }
        @Override public WorkProofDTO deserialize(FastFutureContext serializeContextVar_181, DataIn in_184) {
            String salt_187;
            String suffix_188;
            byte poolSize_189;
            int maxHashVal_190;
            SignedKey globalKey_191;
            byte[] stringData_192;
            var arraySize_193 = DeserializerPackNumber.INSTANCE.put(in_184).intValue();
            stringData_192=new byte[arraySize_193];
            in_184.read(stringData_192);
            salt_187=new String(stringData_192);
            byte[] stringData_194;
            var arraySize_195 = DeserializerPackNumber.INSTANCE.put(in_184).intValue();
            stringData_194=new byte[arraySize_195];
            in_184.read(stringData_194);
            suffix_188=new String(stringData_194);
            poolSize_189=in_184.readByte();
            maxHashVal_190=in_184.readInt();
            globalKey_191=SignedKey.META.deserialize(serializeContextVar_181,in_184);
            return new WorkProofDTO(salt_187,suffix_188,poolSize_189,maxHashVal_190,globalKey_191);
            
        }
        
    };
    public static final FastMetaType<WorkProofDTO> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_196, WorkProofDTO obj_197, DataOut out_198) {
            WorkProofDTO.META_BODY.serialize(serializeContextVar_196, obj_197, out_198);
            
        }
        @Override public WorkProofDTO deserialize(FastFutureContext serializeContextVar_196, DataIn in_199) {
            return WorkProofDTO.META_BODY.deserialize(serializeContextVar_196, in_199);
            
        }
        
    };
    protected final String salt;
    protected final String suffix;
    protected final byte poolSize;
    protected final int maxHashVal;
    protected final SignedKey globalKey;
    public WorkProofDTO(String salt, String suffix, byte poolSize, int maxHashVal, SignedKey globalKey)  {
        if (globalKey == null)  {
            throw new java.lang.NullPointerException("Field 'globalKey' cannot be null.");
            
        }
        this.salt = salt;
        this.suffix = suffix;
        this.poolSize = poolSize;
        this.maxHashVal = maxHashVal;
        this.globalKey = globalKey;
        
    }
    public String getSalt()  {
        return this.salt;
        
    }
    public String getSuffix()  {
        return this.suffix;
        
    }
    public byte getPoolSize()  {
        return this.poolSize;
        
    }
    public int getMaxHashVal()  {
        return this.maxHashVal;
        
    }
    public SignedKey getGlobalKey()  {
        return this.globalKey;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof WorkProofDTO)) return false;
        WorkProofDTO that = (WorkProofDTO) o;
        return java.util.Objects.equals(this.salt, that.salt) && java.util.Objects.equals(this.suffix, that.suffix) && java.util.Objects.equals(this.poolSize, that.poolSize) && java.util.Objects.equals(this.maxHashVal, that.maxHashVal) && java.util.Objects.equals(this.globalKey, that.globalKey);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.salt, this.suffix, this.poolSize, this.maxHashVal, this.globalKey);
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("WorkProofDTO(");
        sb.add("salt:");
        sb.add(this.salt);
        sb.add(", ");
        sb.add("suffix:");
        sb.add(this.suffix);
        sb.add(", ");
        sb.add("poolSize:");
        sb.add(this.poolSize);
        sb.add(", ");
        sb.add("maxHashVal:");
        sb.add(this.maxHashVal);
        sb.add(", ");
        sb.add("globalKey:");
        sb.add(this.globalKey);
        sb.add(')');
        
    }
    
}