/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.AetherCodec;
import io.aether.api.common.CoderAndPort;
import io.aether.api.common.CoderAndPortUtil;
import io.aether.api.common.IPAddress;
import io.aether.api.common.IPAddressAndPorts;
import io.aether.api.common.IPAddressAndPortsList;
import io.aether.api.common.IPAddressUtil;
import io.aether.utils.flow.Flow;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface IPAddressAndPortsListUtil {
    public IPAddressAndPorts[] getAddresses();

    default public URI getURI(AetherCodec codec) {
        for (IPAddressAndPorts a : this.getAddresses()) {
            for (CoderAndPort c : a.getCoderAndPorts()) {
                if (c.getCodec() != codec) continue;
                try {
                    return URI.create(codec.name().toLowerCase() + "://" + InetAddress.getByAddress(a.getAddress().getData()).getHostAddress() + ":" + c.getPort());
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalStateException();
    }

    default public URI[] toURIs() {
        try {
            HashSet<URI> res = new HashSet<URI>();
            for (IPAddressAndPorts a : this.getAddresses()) {
                String inetAddress = InetAddress.getByAddress(a.address.getData()).getHostAddress();
                for (CoderAndPort c : a.getCoderAndPorts()) {
                    res.add(URI.create(c.getCodec().name().toLowerCase() + "://" + inetAddress + ":" + c.getPort()));
                }
            }
            return res.toArray(new URI[0]);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static IPAddressAndPortsList of(List<URI> uris) {
        HashMap<IPAddress, Set> m = new HashMap<IPAddress, Set>();
        for (URI u : uris) {
            for (IPAddress a : IPAddressUtil.of(u)) {
                m.computeIfAbsent(a, k -> new HashSet()).add(u);
            }
        }
        return new IPAddressAndPortsList((IPAddressAndPorts[])Flow.flow(m.entrySet()).map(e -> new IPAddressAndPorts((IPAddress)e.getKey(), (CoderAndPort[])Flow.flow((Set)((Set)e.getValue())).map(CoderAndPortUtil::of).toArray(CoderAndPort.class))).toArray(IPAddressAndPorts.class));
    }
}

