/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.IPAddress;
import io.aether.api.common.IPAddressV4;
import io.aether.api.common.IPAddressV6;
import io.aether.utils.flow.Flow;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public interface IPAddressUtil {
    public static IPAddress[] of(URI uri) {
        try {
            return (IPAddress[])Flow.flow((Object[])InetAddress.getAllByName(uri.getHost())).map(a -> {
                byte[] aa = a.getAddress();
                if (aa.length == 4) {
                    return new IPAddressV4(aa);
                }
                if (aa.length == 6) {
                    return new IPAddressV6(aa);
                }
                throw new UnknownHostException();
            }).toArray(IPAddress.class);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

