/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.IPAddress;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaType;
import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import java.util.Arrays;
import java.util.Objects;

public class IPAddressV6
extends IPAddress
implements ToString {
    public static final FastMetaType<IPAddressV6> META_BODY = new FastMetaType<IPAddressV6>(){

        public void serialize(FastFutureContext serializeContextVar_214, IPAddressV6 obj_215, DataOut out_216) {
            if (obj_215.data.length != 6) {
                throw new IllegalArgumentException("Array length is bad for obj_215.data==" + obj_215.data.length + " but must be 6");
            }
            out_216.write(obj_215.data);
        }

        public IPAddressV6 deserialize(FastFutureContext serializeContextVar_214, DataIn in_217) {
            int arraySize_219 = 6;
            byte[] data_218 = new byte[arraySize_219];
            in_217.read(data_218);
            return new IPAddressV6(data_218);
        }
    };
    public static final FastMetaType<IPAddressV6> META = new FastMetaType<IPAddressV6>(){

        public void serialize(FastFutureContext serializeContextVar_220, IPAddressV6 obj_221, DataOut out_222) {
            META_BODY.serialize(serializeContextVar_220, (Object)obj_221, out_222);
        }

        public IPAddressV6 deserialize(FastFutureContext serializeContextVar_220, DataIn in_223) {
            return (IPAddressV6)META_BODY.deserialize(serializeContextVar_220, in_223);
        }
    };
    protected final byte[] data;

    @Override
    public int getAetherTypeId() {
        return 2;
    }

    public IPAddressV6(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Field 'data' cannot be null.");
        }
        if (data.length != 6) {
            throw new IllegalArgumentException("Array length for field 'data' must be 6 but was " + data.length);
        }
        this.data = data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public boolean dataContains(byte el) {
        return ByteSet.of((byte[])this.data).contains(el);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IPAddressV6)) {
            return false;
        }
        IPAddressV6 that = (IPAddressV6)o;
        return Arrays.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.data));
    }

    @Override
    public String toString() {
        return this.toString2();
    }

    @Override
    public void toString(AString sb) {
        sb.add("IPAddressV6(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
    }
}

