package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class AccessGroup implements io.aether.utils.ToString, AccessGroupUtil  {
    public static final FastMetaType<AccessGroup> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_296, AccessGroup obj_297, DataOut out_298) {
            FastMeta.META_UUID.serialize(serializeContextVar_296,obj_297.owner,out_298);
            out_298.writeLong(obj_297.id);
            SerializerPackNumber.INSTANCE.put(out_298,obj_297.data.length);
            for(var forVar_300:obj_297.data) {
                FastMeta.META_UUID.serialize(serializeContextVar_296,forVar_300,out_298);
                
            }
            
        }
        @Override public AccessGroup deserialize(FastFutureContext serializeContextVar_296, DataIn in_299) {
            UUID owner_301;
            long id_302;
            UUID[] data_303;
            owner_301=FastMeta.META_UUID.deserialize(serializeContextVar_296,in_299);
            id_302=in_299.readLong();
            var arraySize_304 = DeserializerPackNumber.INSTANCE.put(in_299).intValue();
            data_303=new UUID[arraySize_304];
            for(var forVar_305=0; forVar_305<arraySize_304; forVar_305++) {
                data_303[forVar_305]=FastMeta.META_UUID.deserialize(serializeContextVar_296,in_299);
                
            }
            return new AccessGroup(owner_301,id_302,data_303);
            
        }
        
    };
    public static final FastMetaType<AccessGroup> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_306, AccessGroup obj_307, DataOut out_308) {
            AccessGroup.META_BODY.serialize(serializeContextVar_306, obj_307, out_308);
            
        }
        @Override public AccessGroup deserialize(FastFutureContext serializeContextVar_306, DataIn in_309) {
            return AccessGroup.META_BODY.deserialize(serializeContextVar_306, in_309);
            
        }
        
    };
    protected final UUID owner;
    protected final long id;
    protected final UUID[] data;
    public AccessGroup(UUID owner, long id, UUID[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        this.owner = owner;
        this.id = id;
        this.data = data;
        
    }
    public UUID getOwner()  {
        return this.owner;
        
    }
    public long getId()  {
        return this.id;
        
    }
    public UUID[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(UUID el)  {
        return ObjectSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof AccessGroup)) return false;
        AccessGroup that = (AccessGroup) o;
        return java.util.Objects.equals(this.owner, that.owner) && java.util.Objects.equals(this.id, that.id) && java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.owner, this.id, java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("AccessGroup(");
        sb.add("owner:");
        sb.add(this.owner);
        sb.add(", ");
        sb.add("id:");
        sb.add(this.id);
        sb.add(", ");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}