package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HydrogenSignPrivate extends KeySignPrivate implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 4;
        
    }
    public static final FastMetaType<HydrogenSignPrivate> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_112, HydrogenSignPrivate obj_113, DataOut out_114) {
            if(obj_113.data.length!=64) throw new java.lang.IllegalArgumentException("Array length is bad for obj_113.data=="+obj_113.data.length+" but must be 64");
            out_114.write(obj_113.data);
            
        }
        @Override public HydrogenSignPrivate deserialize(FastFutureContext serializeContextVar_112, DataIn in_115) {
            byte[] data_116;
            var arraySize_117=64;
            data_116=new byte[arraySize_117];
            in_115.read(data_116);
            return new HydrogenSignPrivate(data_116);
            
        }
        
    };
    public static final FastMetaType<HydrogenSignPrivate> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_118, HydrogenSignPrivate obj_119, DataOut out_120) {
            HydrogenSignPrivate.META_BODY.serialize(serializeContextVar_118, obj_119, out_120);
            
        }
        @Override public HydrogenSignPrivate deserialize(FastFutureContext serializeContextVar_118, DataIn in_121) {
            return HydrogenSignPrivate.META_BODY.deserialize(serializeContextVar_118, in_121);
            
        }
        
    };
    protected final @L(64) byte[] data;
    public HydrogenSignPrivate(@L(64) byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 64)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 64 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public @L(64) byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof HydrogenSignPrivate)) return false;
        HydrogenSignPrivate that = (HydrogenSignPrivate) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("HydrogenSignPrivate(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}