package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HydrogenSignPublic extends KeySignPublic implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 5;
        
    }
    public static final FastMetaType<HydrogenSignPublic> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_122, HydrogenSignPublic obj_123, DataOut out_124) {
            if(obj_123.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_123.data=="+obj_123.data.length+" but must be 32");
            out_124.write(obj_123.data);
            
        }
        @Override public HydrogenSignPublic deserialize(FastFutureContext serializeContextVar_122, DataIn in_125) {
            byte[] data_126;
            var arraySize_127=32;
            data_126=new byte[arraySize_127];
            in_125.read(data_126);
            return new HydrogenSignPublic(data_126);
            
        }
        
    };
    public static final FastMetaType<HydrogenSignPublic> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_128, HydrogenSignPublic obj_129, DataOut out_130) {
            HydrogenSignPublic.META_BODY.serialize(serializeContextVar_128, obj_129, out_130);
            
        }
        @Override public HydrogenSignPublic deserialize(FastFutureContext serializeContextVar_128, DataIn in_131) {
            return HydrogenSignPublic.META_BODY.deserialize(serializeContextVar_128, in_131);
            
        }
        
    };
    protected final @L(32) byte[] data;
    public HydrogenSignPublic(@L(32) byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public @L(32) byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof HydrogenSignPublic)) return false;
        HydrogenSignPublic that = (HydrogenSignPublic) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("HydrogenSignPublic(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}