package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class IPAddress implements io.aether.utils.ToString, IPAddressUtil  {
    public abstract byte[] getData();
    public abstract int getAetherTypeId();
    public static final FastMetaType<IPAddress> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_200, IPAddress obj_201, DataOut out_202) {
            out_202.writeByte(obj_201.getAetherTypeId());
            switch(obj_201.getAetherTypeId()) {
                case 1: IPAddressV4.META_BODY.serialize(serializeContextVar_200, (IPAddressV4)obj_201, out_202);
                break;
                case 2: IPAddressV6.META_BODY.serialize(serializeContextVar_200, (IPAddressV6)obj_201, out_202);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'IPAddress' with unknown type id " + obj_201.getAetherTypeId());
                
            }
            
        }
        @Override public IPAddress deserialize(FastFutureContext serializeContextVar_200, DataIn in_203) {
            var typeId = in_203.readUByte();
            switch(typeId) {
                case 1: return (IPAddress)IPAddressV4.META_BODY.deserialize(serializeContextVar_200,in_203);
                case 2: return (IPAddress)IPAddressV6.META_BODY.deserialize(serializeContextVar_200,in_203);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'IPAddress'");
                
            }
            
        }
        
    };
    public IPAddress()  {
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof IPAddress)) return false;
        IPAddress that = (IPAddress) o;
        return true;
        
    }
    @Override public int hashCode()  {
        return 0;
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("IPAddress(");
        sb.add(')');
        
    }
    
}