package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class IPAddressAndPorts implements io.aether.utils.ToString  {
    public static final FastMetaType<IPAddressAndPorts> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_234, IPAddressAndPorts obj_235, DataOut out_236) {
            IPAddress.META.serialize(serializeContextVar_234,obj_235.address,out_236);
            SerializerPackNumber.INSTANCE.put(out_236,obj_235.coderAndPorts.length);
            for(var forVar_238:obj_235.coderAndPorts) {
                CoderAndPort.META.serialize(serializeContextVar_234,forVar_238,out_236);
                
            }
            
        }
        @Override public IPAddressAndPorts deserialize(FastFutureContext serializeContextVar_234, DataIn in_237) {
            IPAddress address_239;
            CoderAndPort[] coderAndPorts_240;
            address_239=IPAddress.META.deserialize(serializeContextVar_234,in_237);
            var arraySize_241 = DeserializerPackNumber.INSTANCE.put(in_237).intValue();
            coderAndPorts_240=new CoderAndPort[arraySize_241];
            for(var forVar_242=0; forVar_242<arraySize_241; forVar_242++) {
                coderAndPorts_240[forVar_242]=CoderAndPort.META.deserialize(serializeContextVar_234,in_237);
                
            }
            return new IPAddressAndPorts(address_239,coderAndPorts_240);
            
        }
        
    };
    public static final FastMetaType<IPAddressAndPorts> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_243, IPAddressAndPorts obj_244, DataOut out_245) {
            IPAddressAndPorts.META_BODY.serialize(serializeContextVar_243, obj_244, out_245);
            
        }
        @Override public IPAddressAndPorts deserialize(FastFutureContext serializeContextVar_243, DataIn in_246) {
            return IPAddressAndPorts.META_BODY.deserialize(serializeContextVar_243, in_246);
            
        }
        
    };
    protected final IPAddress address;
    protected final CoderAndPort[] coderAndPorts;
    public IPAddressAndPorts(IPAddress address, CoderAndPort[] coderAndPorts)  {
        if (address == null)  {
            throw new java.lang.NullPointerException("Field 'address' cannot be null.");
            
        }
        if (coderAndPorts == null)  {
            throw new java.lang.NullPointerException("Field 'coderAndPorts' cannot be null.");
            
        }
        this.address = address;
        this.coderAndPorts = coderAndPorts;
        
    }
    public IPAddress getAddress()  {
        return this.address;
        
    }
    public CoderAndPort[] getCoderAndPorts()  {
        return this.coderAndPorts;
        
    }
    public boolean coderAndPortsContains(CoderAndPort el)  {
        return ObjectSet.of(this.coderAndPorts).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof IPAddressAndPorts)) return false;
        IPAddressAndPorts that = (IPAddressAndPorts) o;
        return java.util.Objects.equals(this.address, that.address) && java.util.Arrays.equals(this.coderAndPorts, that.coderAndPorts);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.address, java.util.Arrays.hashCode(this.coderAndPorts));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("IPAddressAndPorts(");
        sb.add("address:");
        sb.add(this.address);
        sb.add(", ");
        sb.add("coderAndPorts:");
        sb.add(this.coderAndPorts);
        sb.add(')');
        
    }
    
}