package io.aether.api.common;


import io.aether.utils.flow.Flow;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.*;

public interface IPAddressAndPortsListUtil {
    IPAddressAndPorts[] getAddresses();

    default URI getURI(AetherCodec codec) {
        for (var a : getAddresses()) {
            for (var c : a.getCoderAndPorts()) {
                if (c.getCodec() == codec) {
                    try {
                        return URI.create(codec.name().toLowerCase() + "://" + InetAddress.getByAddress(a.getAddress().getData()).getHostAddress() + ":" + c.getPort());
                    } catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    default URI[] toURIs() {
        try {
            Set<URI> res = new HashSet<>();
            for (var a : getAddresses()) {
                var inetAddress = InetAddress.getByAddress(a.address.getData()).getHostAddress();
                for (var c : a.getCoderAndPorts()) {
                    res.add(URI.create(c.getCodec().name().toLowerCase() + "://" + inetAddress + ":" + c.getPort()));
                }
            }
            return res.toArray(new URI[0]);
        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    static IPAddressAndPortsList of(List<URI> uris) {
        Map<IPAddress, Set<URI>> m = new HashMap<>();
        for (var u : uris) {
            for (var a : IPAddressUtil.of(u)) {
                m.computeIfAbsent(a, k -> new HashSet<>()).add(u);
            }
        }
        return new IPAddressAndPortsList(Flow.flow(m.entrySet())
                .map(e -> new IPAddressAndPorts(e.getKey(), Flow.flow(e.getValue()).map(CoderAndPortUtil::of).toArray(CoderAndPort.class))).toArray(IPAddressAndPorts.class));
    }
}
