package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class IPAddressV4 extends IPAddress implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 1;
        
    }
    public static final FastMetaType<IPAddressV4> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_204, IPAddressV4 obj_205, DataOut out_206) {
            if(obj_205.data.length!=4) throw new java.lang.IllegalArgumentException("Array length is bad for obj_205.data=="+obj_205.data.length+" but must be 4");
            out_206.write(obj_205.data);
            
        }
        @Override public IPAddressV4 deserialize(FastFutureContext serializeContextVar_204, DataIn in_207) {
            byte[] data_208;
            var arraySize_209=4;
            data_208=new byte[arraySize_209];
            in_207.read(data_208);
            return new IPAddressV4(data_208);
            
        }
        
    };
    public static final FastMetaType<IPAddressV4> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_210, IPAddressV4 obj_211, DataOut out_212) {
            IPAddressV4.META_BODY.serialize(serializeContextVar_210, obj_211, out_212);
            
        }
        @Override public IPAddressV4 deserialize(FastFutureContext serializeContextVar_210, DataIn in_213) {
            return IPAddressV4.META_BODY.deserialize(serializeContextVar_210, in_213);
            
        }
        
    };
    protected final @L(4) byte[] data;
    public IPAddressV4(@L(4) byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 4)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 4 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public @L(4) byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof IPAddressV4)) return false;
        IPAddressV4 that = (IPAddressV4) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("IPAddressV4(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}