package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class IPAddressV6 extends IPAddress implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 2;
        
    }
    public static final FastMetaType<IPAddressV6> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_214, IPAddressV6 obj_215, DataOut out_216) {
            if(obj_215.data.length!=6) throw new java.lang.IllegalArgumentException("Array length is bad for obj_215.data=="+obj_215.data.length+" but must be 6");
            out_216.write(obj_215.data);
            
        }
        @Override public IPAddressV6 deserialize(FastFutureContext serializeContextVar_214, DataIn in_217) {
            byte[] data_218;
            var arraySize_219=6;
            data_218=new byte[arraySize_219];
            in_217.read(data_218);
            return new IPAddressV6(data_218);
            
        }
        
    };
    public static final FastMetaType<IPAddressV6> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_220, IPAddressV6 obj_221, DataOut out_222) {
            IPAddressV6.META_BODY.serialize(serializeContextVar_220, obj_221, out_222);
            
        }
        @Override public IPAddressV6 deserialize(FastFutureContext serializeContextVar_220, DataIn in_223) {
            return IPAddressV6.META_BODY.deserialize(serializeContextVar_220, in_223);
            
        }
        
    };
    protected final @L(6) byte[] data;
    public IPAddressV6(@L(6) byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 6)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 6 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public @L(6) byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof IPAddressV6)) return false;
        IPAddressV6 that = (IPAddressV6) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("IPAddressV6(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}