package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class MoneyOperation implements io.aether.utils.ToString  {
    public static final FastMetaType<MoneyOperation> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_281, MoneyOperation obj_282, DataOut out_283) {
            out_283.writeLong(obj_282.id);
            FastMeta.META_UUID.serialize(serializeContextVar_281,obj_282.from,out_283);
            FastMeta.META_UUID.serialize(serializeContextVar_281,obj_282.to,out_283);
            out_283.writeLong(obj_282.amount);
            out_283.writeLong(obj_282.time);
            out_283.writeByte(obj_282.credit?1:0);
            Status.META.serialize(serializeContextVar_281,obj_282.status,out_283);
            
        }
        @Override public MoneyOperation deserialize(FastFutureContext serializeContextVar_281, DataIn in_284) {
            long id_285;
            UUID from_286;
            UUID to_287;
            long amount_288;
            long time_289;
            boolean credit_290;
            Status status_291;
            id_285=in_284.readLong();
            from_286=FastMeta.META_UUID.deserialize(serializeContextVar_281,in_284);
            to_287=FastMeta.META_UUID.deserialize(serializeContextVar_281,in_284);
            amount_288=in_284.readLong();
            time_289=in_284.readLong();
            credit_290=in_284.readByte()>0;
            status_291=Status.META.deserialize(serializeContextVar_281,in_284);
            return new MoneyOperation(id_285,from_286,to_287,amount_288,time_289,credit_290,status_291);
            
        }
        
    };
    public static final FastMetaType<MoneyOperation> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_292, MoneyOperation obj_293, DataOut out_294) {
            MoneyOperation.META_BODY.serialize(serializeContextVar_292, obj_293, out_294);
            
        }
        @Override public MoneyOperation deserialize(FastFutureContext serializeContextVar_292, DataIn in_295) {
            return MoneyOperation.META_BODY.deserialize(serializeContextVar_292, in_295);
            
        }
        
    };
    protected final long id;
    protected final UUID from;
    protected final UUID to;
    protected final long amount;
    protected final long time;
    protected final boolean credit;
    protected final Status status;
    public MoneyOperation(long id, UUID from, UUID to, long amount, long time, boolean credit, Status status)  {
        if (status == null)  {
            throw new java.lang.NullPointerException("Field 'status' cannot be null.");
            
        }
        this.id = id;
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.time = time;
        this.credit = credit;
        this.status = status;
        
    }
    public long getId()  {
        return this.id;
        
    }
    public UUID getFrom()  {
        return this.from;
        
    }
    public UUID getTo()  {
        return this.to;
        
    }
    public long getAmount()  {
        return this.amount;
        
    }
    public long getTime()  {
        return this.time;
        
    }
    public boolean isCredit()  {
        return this.credit;
        
    }
    public Status getStatus()  {
        return this.status;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof MoneyOperation)) return false;
        MoneyOperation that = (MoneyOperation) o;
        return java.util.Objects.equals(this.id, that.id) && java.util.Objects.equals(this.from, that.from) && java.util.Objects.equals(this.to, that.to) && java.util.Objects.equals(this.amount, that.amount) && java.util.Objects.equals(this.time, that.time) && java.util.Objects.equals(this.credit, that.credit) && java.util.Objects.equals(this.status, that.status);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.id, this.from, this.to, this.amount, this.time, this.credit, this.status);
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("MoneyOperation(");
        sb.add("id:");
        sb.add(this.id);
        sb.add(", ");
        sb.add("from:");
        sb.add(this.from);
        sb.add(", ");
        sb.add("to:");
        sb.add(this.to);
        sb.add(", ");
        sb.add("amount:");
        sb.add(this.amount);
        sb.add(", ");
        sb.add("time:");
        sb.add(this.time);
        sb.add(", ");
        sb.add("credit:");
        sb.add(this.credit);
        sb.add(", ");
        sb.add("status:");
        sb.add(this.status);
        sb.add(')');
        
    }
    
}