package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class PairKeys implements io.aether.utils.ToString  {
    public abstract Key getPrivateKey();
    public abstract int getAetherTypeId();
    public static final FastMetaType<PairKeys> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_320, PairKeys obj_321, DataOut out_322) {
            out_322.writeByte(obj_321.getAetherTypeId());
            switch(obj_321.getAetherTypeId()) {
                case 3: PairKeysSign.META_BODY.serialize(serializeContextVar_320, (PairKeysSign)obj_321, out_322);
                break;
                case 1: PairKeysAsym.META_BODY.serialize(serializeContextVar_320, (PairKeysAsym)obj_321, out_322);
                break;
                case 2: PairKeysAsymSigned.META_BODY.serialize(serializeContextVar_320, (PairKeysAsymSigned)obj_321, out_322);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'PairKeys' with unknown type id " + obj_321.getAetherTypeId());
                
            }
            
        }
        @Override public PairKeys deserialize(FastFutureContext serializeContextVar_320, DataIn in_323) {
            var typeId = in_323.readUByte();
            switch(typeId) {
                case 3: return (PairKeys)PairKeysSign.META_BODY.deserialize(serializeContextVar_320,in_323);
                case 1: return (PairKeys)PairKeysAsym.META_BODY.deserialize(serializeContextVar_320,in_323);
                case 2: return (PairKeys)PairKeysAsymSigned.META_BODY.deserialize(serializeContextVar_320,in_323);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'PairKeys'");
                
            }
            
        }
        
    };
    public PairKeys()  {
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof PairKeys)) return false;
        PairKeys that = (PairKeys) o;
        return true;
        
    }
    @Override public int hashCode()  {
        return 0;
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("PairKeys(");
        sb.add(')');
        
    }
    
}