package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class PairKeysAsymSigned extends PairKeys implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 2;
        
    }
    public static final FastMetaType<PairKeysAsymSigned> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_344, PairKeysAsymSigned obj_345, DataOut out_346) {
            Key.META.serialize(serializeContextVar_344,obj_345.privateKey,out_346);
            SignedKey.META.serialize(serializeContextVar_344,obj_345.publicKey,out_346);
            
        }
        @Override public PairKeysAsymSigned deserialize(FastFutureContext serializeContextVar_344, DataIn in_347) {
            Key privateKey_348;
            SignedKey publicKey_349;
            privateKey_348=Key.META.deserialize(serializeContextVar_344,in_347);
            publicKey_349=SignedKey.META.deserialize(serializeContextVar_344,in_347);
            return new PairKeysAsymSigned(privateKey_348,publicKey_349);
            
        }
        
    };
    public static final FastMetaType<PairKeysAsymSigned> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_350, PairKeysAsymSigned obj_351, DataOut out_352) {
            PairKeysAsymSigned.META_BODY.serialize(serializeContextVar_350, obj_351, out_352);
            
        }
        @Override public PairKeysAsymSigned deserialize(FastFutureContext serializeContextVar_350, DataIn in_353) {
            return PairKeysAsymSigned.META_BODY.deserialize(serializeContextVar_350, in_353);
            
        }
        
    };
    protected final Key privateKey;
    protected final SignedKey publicKey;
    public PairKeysAsymSigned(Key privateKey, SignedKey publicKey)  {
        if (privateKey == null)  {
            throw new java.lang.NullPointerException("Field 'privateKey' cannot be null.");
            
        }
        if (publicKey == null)  {
            throw new java.lang.NullPointerException("Field 'publicKey' cannot be null.");
            
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        
    }
    public Key getPrivateKey()  {
        return this.privateKey;
        
    }
    public SignedKey getPublicKey()  {
        return this.publicKey;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof PairKeysAsymSigned)) return false;
        PairKeysAsymSigned that = (PairKeysAsymSigned) o;
        return java.util.Objects.equals(this.privateKey, that.privateKey) && java.util.Objects.equals(this.publicKey, that.publicKey);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.privateKey, this.publicKey);
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("PairKeysAsymSigned(");
        sb.add("privateKey:");
        sb.add(this.privateKey);
        sb.add(", ");
        sb.add("publicKey:");
        sb.add(this.publicKey);
        sb.add(')');
        
    }
    
}