package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class ServerDescriptor implements io.aether.utils.ToString  {
    public static final FastMetaType<ServerDescriptor> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_259, ServerDescriptor obj_260, DataOut out_261) {
            out_261.writeShort(obj_260.id);
            IPAddressAndPortsList.META.serialize(serializeContextVar_259,obj_260.ipAddress,out_261);
            
        }
        @Override public ServerDescriptor deserialize(FastFutureContext serializeContextVar_259, DataIn in_262) {
            short id_263;
            IPAddressAndPortsList ipAddress_264;
            id_263=in_262.readShort();
            ipAddress_264=IPAddressAndPortsList.META.deserialize(serializeContextVar_259,in_262);
            return new ServerDescriptor(id_263,ipAddress_264);
            
        }
        
    };
    public static final FastMetaType<ServerDescriptor> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_265, ServerDescriptor obj_266, DataOut out_267) {
            ServerDescriptor.META_BODY.serialize(serializeContextVar_265, obj_266, out_267);
            
        }
        @Override public ServerDescriptor deserialize(FastFutureContext serializeContextVar_265, DataIn in_268) {
            return ServerDescriptor.META_BODY.deserialize(serializeContextVar_265, in_268);
            
        }
        
    };
    protected final short id;
    protected final IPAddressAndPortsList ipAddress;
    public ServerDescriptor(short id, IPAddressAndPortsList ipAddress)  {
        if (ipAddress == null)  {
            throw new java.lang.NullPointerException("Field 'ipAddress' cannot be null.");
            
        }
        this.id = id;
        this.ipAddress = ipAddress;
        
    }
    public short getId()  {
        return this.id;
        
    }
    public IPAddressAndPortsList getIpAddress()  {
        return this.ipAddress;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof ServerDescriptor)) return false;
        ServerDescriptor that = (ServerDescriptor) o;
        return java.util.Objects.equals(this.id, that.id) && java.util.Objects.equals(this.ipAddress, that.ipAddress);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.id, this.ipAddress);
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("ServerDescriptor(");
        sb.add("id:");
        sb.add(this.id);
        sb.add(", ");
        sb.add("ipAddress:");
        sb.add(this.ipAddress);
        sb.add(')');
        
    }
    
}