package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class SodiumCurvePrivate extends KeyAsymmetricPrivate implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 7;
        
    }
    public static final FastMetaType<SodiumCurvePrivate> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_82, SodiumCurvePrivate obj_83, DataOut out_84) {
            if(obj_83.data.length!=32) throw new java.lang.IllegalArgumentException("Array length is bad for obj_83.data=="+obj_83.data.length+" but must be 32");
            out_84.write(obj_83.data);
            
        }
        @Override public SodiumCurvePrivate deserialize(FastFutureContext serializeContextVar_82, DataIn in_85) {
            byte[] data_86;
            var arraySize_87=32;
            data_86=new byte[arraySize_87];
            in_85.read(data_86);
            return new SodiumCurvePrivate(data_86);
            
        }
        
    };
    public static final FastMetaType<SodiumCurvePrivate> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_88, SodiumCurvePrivate obj_89, DataOut out_90) {
            SodiumCurvePrivate.META_BODY.serialize(serializeContextVar_88, obj_89, out_90);
            
        }
        @Override public SodiumCurvePrivate deserialize(FastFutureContext serializeContextVar_88, DataIn in_91) {
            return SodiumCurvePrivate.META_BODY.deserialize(serializeContextVar_88, in_91);
            
        }
        
    };
    protected final @L(32) byte[] data;
    public SodiumCurvePrivate(@L(32) byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 32)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 32 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public @L(32) byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof SodiumCurvePrivate)) return false;
        SodiumCurvePrivate that = (SodiumCurvePrivate) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("SodiumCurvePrivate(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}